package com.agilex.healthcare.mobilehealthplatform.restservice.staffdirectory;

import static org.junit.Assert.assertTrue;

import java.net.URI;
import java.net.URISyntaxException;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.mobilehealthplatform.domain.StaffDirectorySearchResults;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;

public class StaffDirectoryResourceVeteranTest {

	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(StaffDirectoryResourceVeteranTest.class);

	private static ResourceDirectory resourceDirectory = null;
	private static MobileHealthClientTestVersion client;
	private static Client jerseyClient;
	private static MhpUser mhpUser = null;
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInProperModes() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		client = TestHelper.createMobileHealthClient();
		jerseyClient = client.getJerseyClient();
		
		URI resourceDirectoryURI = IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri();
		resourceDirectory = jerseyClient.resource(resourceDirectoryURI).accept("application/xml").get(ResourceDirectory.class);
		
		URI mhpUserResourceUri = getMhpUserResourceUri();
		mhpUser = getMhpUser(mhpUserResourceUri);
	}
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void validateGetLatestStaffUserDisclaimerContent() throws URISyntaxException {
		URI uri = createStaffDirectoryUri(mhpUser,"688","patient01");
		
		boolean error = false;
		try {
			client.getJerseyClient().resource(uri).get(StaffDirectorySearchResults.class);
		} catch (UniformInterfaceException e) {
			if (e.getResponse().getStatus() == 403) {
				error = true;
			}
		}
		
		assertTrue("veteran should get 403 when attempting to access", error);
		
	}

	private static URI createStaffDirectoryUri(MhpUser mhpUser, String facilityCode, String term) throws URISyntaxException {
		URI uri = getUriForTitle(LinkTitles.StaffDirectory, mhpUser.getLink());
		
		return UriBuilder.fromUri(uri).path("site").path(facilityCode).path("staff").queryParam("term", term).build();
	}
	
	private static MhpUser getMhpUser(URI mhpUserResourceUri) {
		return client.getJerseyClient().resource(mhpUserResourceUri).get(MhpUser.class);		
	}
	
	private static URI getMhpUserResourceUri() {
		URI mhpUserResourceUri = null;
		AtomLinks links = resourceDirectory.getLink();
		mhpUserResourceUri = getUriForTitle(LinkTitles.MHPUser, links);
		return mhpUserResourceUri;
	}
	
	private static URI getUriForTitle(String title, AtomLinks links) {
		URI targetUri = null;
		for (AtomLink atomLink : links) {
			if(atomLink.getTitle().equals(title)){
				targetUri = atomLink.getHref();
				break;
			}
		}
		
		return targetUri;
	}
}
