package com.agilex.healthcare.mobilehealthplatform.restservice.provider;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.Client;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProviderResourceTest {

	private ResourceDirectory resourceDirectory;
	private URI primaryCareProvidersUri;
	private URI mentalHealthProvidersUri;
	private URI mostRecentFacilitiesUri;


	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void setup() {
		client = TestHelper.createMobileHealthClient("zztest.patient01", "pass", "oauth");
	}

	@AfterClass
	public static void destroy() {
		if (client != null){
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	public ProviderResourceTest() {
		Client jerseyClient = new Client();
		resourceDirectory = jerseyClient.resource(getResourceDirectoryURI()).accept("application/xml").get(ResourceDirectory.class);
		MhpUser mhpUser = client.getJerseyClient().resource(getMhpUserLink()).accept("application/xml").get(MhpUser.class);
		primaryCareProvidersUri = getPrimarCareProvidersLink(mhpUser);
		mentalHealthProvidersUri = getMentalHealthProvidersLink(mhpUser);
		mostRecentFacilitiesUri = getMostRecentFacilitiesLink(mhpUser);
	}

    private URI getPrimarCareProvidersLink(MhpUser mhpUser){
		return getLink(mhpUser.getLink(), LinkTitles.PrimaryCareProviders);
	}

	private URI getMentalHealthProvidersLink(MhpUser mhpUser){
		return getLink(mhpUser.getLink(), LinkTitles.MentalHealthProviders);
	}

	private URI getMostRecentFacilitiesLink(MhpUser mhpUser){
		return getLink(mhpUser.getLink(), LinkTitles.MostRecentFacilities);
	}

	private URI getMhpUserLink(){
		AtomLinks links = resourceDirectory.getLink();
		return getLink(links, LinkTitles.MHPUser);
	}

	private URI getLink(AtomLinks links, String title){
		for (AtomLink atomLink : links) {
			if(atomLink.getTitle().equals(title)){
				return atomLink.getHref();
			}
		}
		return null;
	}
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode( "va-veteran-dev"));
	}

	@Test
	public void verifyValidPrimaryCareProvidersAreReturned() {
		PatientProviders providers = client.getJerseyClient().resource(primaryCareProvidersUri).queryParam("facilitySiteCode", "688").accept("application/xml").accept("application/xml").get(PatientProviders.class);
		assertEquals(2, providers.size());
	}

	@Test
	public void verifyValidMentalHealthProvidersAreReturned() {
		PatientProviders providers = client.getJerseyClient().resource(mentalHealthProvidersUri).accept("application/xml").get(PatientProviders.class);
        assertNotNull(providers);
//        assertEquals(3, providers.size());
	}

	@Test
	public void verifyValidMentalHealthProvidersWithFacilityFilterAreReturned() {
        PatientProviders providers = client.getJerseyClient().resource(mentalHealthProvidersUri).queryParam("facilitySiteCode", "688").accept("application/xml").get(PatientProviders.class);
        assertNotNull(providers);
//        assertEquals(3, providers.size());
	}

	@Test
	public void verifyValidFacilitiesAreReturned() {
		Facilities facilities = client.getJerseyClient().resource(mostRecentFacilitiesUri).accept("application/xml").get(Facilities.class);
		assertTrue(facilities.size() >= 0);
	}
	
	private URI getResourceDirectoryURI() {
		return IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri();
	}
}
