package com.agilex.healthcare.mobilehealthplatform.restservice.preference;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URI;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientPreference;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientPreferenceResourceTest {

	private static MobileHealthClientTestVersion client;
	private static URI prefReqUri;
	private static Patient patient;
	
    @BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("dev", "va-veteran-dev"));
		patient = PatientLoader.loadTestPatient();
		client = TestHelper.createMobileHealthClient();
		prefReqUri = getPatientPrefRequestsUri();
		//prefReq = client.getJerseyClient().resource(prefReqUri).type(MediaType.APPLICATION_XML).accept("application/xml").get(PatientPreference.class);
	}

    @AfterClass
	public static void tearDown(){
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}


    @Test
	public void retrievePref() {
		PatientPreference pref = retrievePreference(prefReqUri);
		assertNotNull(pref);
	}

    @Test
	public void savePref() {
    		PatientPreference test = new PatientPreference();
    		test.setPatientIdentifier(patient.getPatientIdentifier());
    		test.setEmailAddress("test2@test.com");
    		test.setTextMsgPhNumber("123-123-1234");
    		test.setEmailAllowed(true);
            test.setNotificationFrequency("Never");
		PatientPreference pref = client.getJerseyClient().resource(prefReqUri).put(PatientPreference.class, test);
		assertNotNull(pref);
		assertEquals("test2@test.com", pref.getEmailAddress());
	}


	private PatientPreference retrievePreference(URI appointmentsBaseUri) {
		PatientPreference prefRequests = client.getJerseyClient().resource(prefReqUri).get(PatientPreference.class);
		return prefRequests;
	}

	private static URI getPatientPrefRequestsUri() {
		URI prefUri = patient.getLink().getUriByTitle(LinkTitles.PatientPreference);
		return prefUri;
	}

}
