package com.agilex.healthcare.mobilehealthplatform.restservice.patients.links;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;

public class PatientsResourceLinksTest {
	private static Node patientAsXml;

	protected static Node getPatient() {
		return patientAsXml;
	}

	protected static void setPatient(Node patientAsXml) {
		PatientsResourceLinksTest.patientAsXml = patientAsXml;
	}

	@BeforeClass
	public static void loadPatients() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
	
		System.out.println("load patients");

		URI rootPatientsUri = IntegrationTestConfiguration.getResourceUri("patients");
		URI patientSearchUri = UriBuilder.fromUri(rootPatientsUri).queryParam("lastname", "PATIENT01").build();

		Client client = TestHelper.createMobileHealthClient().getJerseyClient();

		Document patientsAsXml = client.resource(patientSearchUri).accept(MediaType.APPLICATION_XML.toString()).get(Document.class);
		setPatient(XpathHelper.getNode(patientsAsXml, "m:patients/m:patient"));
		System.out.println("loaded patients");
		
		client.destroy();
	}

	@Test
	public void patientHasLinks() {
		NodeList linkNodes = XpathHelper.getNodeList(getPatient(), "atom:link");
		assertTrue(linkNodes.getLength() > 0);
		System.out.println("patient has " + linkNodes.getLength() + " atom links");
	}

	@Test(expected = AssertionError.class)
	public void patientDoesNotHaveBunkLink() {
		validateLinkExists("invalid-title");
	}

	@Test
	public void validatePatientIdentifiers() {
		validateLinkExists("patient-identifiers");
	}
	
	@Test
	public void validateDemographics() {
		validateLinkExists("patient-demographics");
	}

	@Test
	public void validateDocuments() {
		validateLinkExists("patient-documents");
	}

	@Test
	public void validateImage() {
		validateLinkExists("patient-image");
	}

	@Test
	public void validateProblems() {
		validateLinkExists("patient-problems");
	}

	@Test
	public void validateAllergies() {
		validateLinkExists("patient-allergies");
	}

	@Test
	public void validateSurgeries() {
		validateLinkExists("patient-surgeries");
	}

	@Test
	public void validateMood() {
		validateLinkExists("patient-mood");
	}

	@Test
	public void validateExercise() {
		validateLinkExists("patient-exercise");
	}

	@Test
	public void validateSurgery() {
		validateLinkExists("patient-surgeries");
	}

	@Test
	public void validateVitalsGraph() {
		validateLinkExists("patient-entered-vitals-graphdata");
	}

	@Test
	public void validateVitalsTable() {
		validateLinkExists("patient-entered-vitals-tabledata");
	}

	@Test
	public void validateAppointmentsPast() {
		validateLinkExists("patient-appointments-past");
	}

	@Test
	public void validateAppointments() {
		validateLinkExists("patient-appointments");
	}

	@Test
	public void validateCalendarEvents() {
		validateLinkExists("patient-calendar-events");
	}

	@Test
	public void validateCalendarPublicKey() {
		validateLinkExists("patient-calendar-publickey");
	}

	@Test
	public void validateDiet() {
		validateLinkExists("patient-diet");
	}

	@Test
	public void validateContactLogs() {
		validateLinkExists("patient-contactlogs");
	}

	@Test
	public void validateAdmissionsLogs() {
		validateLinkExists("patient-admisions");
	}

	@Test
	public void validateDailyEventsLogs() {
		validateLinkExists("patient-daily-events");
	}

	@Test
	public void validateRadiologyTest() {
		validateLinkExists("patient-radiology-tests");
	}

	@Test
	public void validateRadiologyResult() {
		validateLinkExists("patient-radiology-results");
	}

	@Test
	public void validateMedications() {
		validateLinkExists("patient-medications");
	}

	@Test
	public void validateActiveMedications() {
		validateLinkExists("patient-medications-active");
	}

	@Test
	public void validateOutpatienMedications() {
		validateLinkExists("patient-medications-outpatient");
	}

	@Test
	public void validateInpatientMedications() {
		validateLinkExists("patient-medications-inpatient");
	}

	@Test
	public void validateActiveOutpatientMedications() {
		validateLinkExists("patient-medications-outpatient-active");
	}

	@Test
	public void validateActiveInpatientMedications() {
		validateLinkExists("patient-medications-inpatient-active");
	}

	@Test
	public void validateLabResults() {
		validateLinkExists("patient-lab-results");
	}

	@Test
	public void validateLabTests() {
		validateLinkExists("patient-lab-tests");
	}

	@Test
	public void validateLabTestsByGroup() {
		validateLinkExists("patient-lab-tests-by-group");
	}

	@Test
	public void validateLabMicroResults() {
		validateLinkExists("patient-lab-micro-results");
	}

	@Test
	public void validateLabMicroTests() {
		validateLinkExists("patient-lab-micro-tests");
	}

	@Test
	public void validateLabMicroTestsByGroup() {
		validateLinkExists("patient-lab-micro-tests-by-group");
	}

	@Test
	public void validateNotifications() {
		validateLinkExists("patient-notifications");
	}

	@Test
	public void validateDevices() {
		validateLinkExists("patient-devices");
	}

	@Test
	public void validateMedicationRefills() {
		validateLinkExists("patient-medication-refills");
	}
	
	private void validateLinkExists(String title) {
		Node linkNode = XpathHelper.getNode(getPatient(), "atom:link[@title='" + title + "']");
		assertNotNull(linkNode);
	}

}
