package com.agilex.healthcare.mobilehealthplatform.restservice.patients;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriBuilder;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientSearchResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.restservice.GeneralResourceTestBase;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientsResourceTest extends GeneralResourceTestBase {

	private static MobileHealthClientTestVersion client;

	@Override
	protected String getResourcePath() {
		return IntegrationTestConfiguration.getMobileHealthServerBaseUri() + "/patients?lastname=younger";
	}

	@BeforeClass
	public static void onlyRunInVaProviderDev() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
	}

	
	@Before
	public  void validateMode() {
		client = TestHelper.createMobileHealthClient();
	}

	@After
	public void destroy() {
		client.getJerseyClient().destroy();
		client = null;
	}

	
	@Test
	public void testInternalPatientDataStoreForVaProviderDevMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		try {
			
			URI uri = createInternalPatientSearchUri();
			Patients patients = client.getJerseyClient().resource(uri).get(PatientSearchResults.class);
			
			assertNotNull(patients);
			assert(patients.size() >= 20);
			
		} catch (WebApplicationException e) {
			assertEquals(404, e.getResponse().getStatus());
		}
	}

	private URI createInternalPatientSearchUri() {
		
		StringBuilder sb = new StringBuilder(IntegrationTestConfiguration.getMobileHealthServerBaseUri().toString());
		
		sb.append("/patients?searchstring=patient26");
		
		return UriBuilder.fromUri(sb.toString()).build();
	}

}
