package com.agilex.healthcare.mobilehealthplatform.restservice.patients;

import static org.junit.Assert.assertEquals;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientSortTest {

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void setup() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if(client != null){
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void validateSortingIsBeingDoneinAscendingOrder() {
		Patients patients = client.getPatientResourceClient().patientSearch("patient26");
		Patient expectedPatient = IntegrationTestConfiguration.getFirst     Patient();
		assertEquals(expectedPatient.getFirstName().toUpperCase(), patients.get(0).getFirstName().toUpperCase());
	}

}
