package com.agilex.healthcare.mobilehealthplatform.restservice.patients;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientSearchBySearchStringViaClientApiTest {

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void setup() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if(client != null){
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	private Patients performTest(String searchString, int expectedNumberOfRows, String exptectedLastName) {
		Patients patients = client.getPatientResourceClient().patientSearch(searchString);
		assertTrue(patients.size() == expectedNumberOfRows);
		for (Patient patient : patients)
			assertEquals(exptectedLastName.toLowerCase(), patient.getLastName().toLowerCase());
		return patients;
	}

	@Test
	public void searchByLastName() {
		String searchString = IntegrationTestConfiguration.getTestPatient().getLastName();
		String expectedLastName = IntegrationTestConfiguration.getTestPatient().getLastName();
		int expectedNumOfRecords = 1;
		performTest(searchString, expectedNumOfRecords, expectedLastName);
	}

	@Test
	public void searchByLastFirstName() {
		String searchString = IntegrationTestConfiguration.getTestPatient().getLastName()+","+IntegrationTestConfiguration.getTestPatient().getFirstName();
		String expectedLastName = IntegrationTestConfiguration.getTestPatient().getLastName();
		int expectedNumOfRecords = 1;
		performTest(searchString, expectedNumOfRecords, expectedLastName);
	}
	@Test
	public void searchBySsn() {
		String searchString = "999-99-9901";
		String expectedLastName = IntegrationTestConfiguration.getTestPatient().getLastName();
		int expectedNumOfRecords = 1;
		performTest(searchString, expectedNumOfRecords, expectedLastName);
	}
	@Test
	public void searchBySsnWithoutDash() {
		String searchString = "999999901";
		String expectedLastName = IntegrationTestConfiguration.getTestPatient().getLastName();
		int expectedNumOfRecords = 1;
		performTest(searchString, expectedNumOfRecords, expectedLastName);
	}
	@Test
	public void searchBySsnPattern() {
		String searchString = "P9901";
		String expectedLastName = IntegrationTestConfiguration.getTestPatient().getLastName();
		int expectedNumOfRecords = 1;
		performTest(searchString, expectedNumOfRecords, expectedLastName);
	}
}
