package com.agilex.healthcare.mobilehealthplatform.restservice.patients;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.GregorianCalendar;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.clientapi.PatientResourceClient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientSearchByPrototypeViaClientApiTest {
	private static MobileHealthClientTestVersion mobileHealthClient;
	private static PatientResourceClient patientResource = null;
	
	@BeforeClass
	public static void setup() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		mobileHealthClient = TestHelper.createMobileHealthClient();
		patientResource = mobileHealthClient.getPatientResourceClient();
	}
	
	@AfterClass
	public static void destroy() {
		if(mobileHealthClient != null){
			mobileHealthClient.getJerseyClient().destroy();
			mobileHealthClient = null;
			patientResource = null;
		}
	}

	@Test
	public void validateNoMatchReturnsEmptyCollection() {
		Patient prototype = new Patient();
		prototype.setLastName("XYZ");
		Patients patients = patientResource.patientSearch(prototype);
		assertEquals(0, patients.size());
	}

	@Test
	public void validateOneMatchReturnsCollectionWithSizeOne() {
		Patient prototype = new Patient();
		prototype.setLastName("Patient01");
		Patients patients = patientResource.patientSearch(prototype);
		assertEquals(1, patients.size());
	}

	@Test
	public void validateOneMatchReturnsCollectionWithCorrectPatient() {
		Patient prototype = new Patient();
		prototype.setLastName("Patient01");
		Patients patients = patientResource.patientSearch(prototype);
		assertEquals(prototype.getLastName().toLowerCase(), patients.get(0).getLastName().toLowerCase());
	}

	@Ignore
	public void validateTwoMatchesReturnsCollectionWithSizeTwo() {
		Patient prototype = new Patient();
		prototype.setLastName("Ashford");
		Patients patients = patientResource.patientSearch(prototype);
		assertTrue(patients.size() > 1);

		for (Patient patient : patients) {
			assertEquals(prototype.getLastName().toLowerCase(), patient.getLastName().toLowerCase());
		}
	}

	@Test
	public void validateNullInputReturnsEmptyCollection() {
		Patient prototype = new Patient();
		Patients patients = patientResource.patientSearch(prototype);
		assertEquals(0, patients.size());
	}

	@Ignore
	public void validateOneMatchByFirstAndLastReturnsCollectionWithCorrectPatient() {
		Patient prototype = new Patient();
		prototype.setFirstName("Mike");
		prototype.setLastName("Ashford");
		Patients patients = patientResource.patientSearch(prototype);
		assertEquals(1, patients.size());
		assertEquals("Mike".toLowerCase(), patients.get(0).getFirstName().toLowerCase());
		assertEquals("Ashford".toLowerCase(), patients.get(0).getLastName().toLowerCase());
	}

	@Test
	public void validateOneMatchIgnoringCaseReturnsCollectionWithCorrectPatient() {
		Patient prototype = new Patient();
		prototype.setLastName("Patient01");
		Patients patients = patientResource.patientSearch(prototype);
		assertEquals("Patient01".toLowerCase(), patients.get(0).getLastName().toLowerCase());
	}

	@Test
	public void validateFirstNameReturned() {
		Patient prototype = new Patient();
		prototype.setLastName("Patient01");
		Patients patients = patientResource.patientSearch(prototype);
		Patient patient = patients.get(0);
		assertEquals("zztest".toLowerCase(), patient.getFirstName().toLowerCase().substring(0, 6));
	}

	@Ignore
	public void validateDateReturned() {
		GregorianCalendar expected = new GregorianCalendar(05, 05, 1975);
		Patient prototype = new Patient();
		prototype.setLastName("Patient01");
		Patients patients = patientResource.patientSearch(prototype);
		Patient patient = patients.get(0);
		assertEquals(expected, patient.getDateOfBirth());
	}

	@Test
	public void validateGenderReturned() {
		String expected = "M";
		Patient prototype = new Patient();
		prototype.setLastName("Patient01");
		Patients patients = patientResource.patientSearch(prototype);
		Patient patient = patients.get(0);
		assertEquals(expected, patient.getGender().substring(0, 1));
	}

	@Ignore
	public void validatePatientIdNotReturned() {
		Patient prototype = new Patient();
		prototype.setLastName("Patient01");
		Patients patients = patientResource.patientSearch(prototype);
		Patient patient = patients.get(0);
		assertNull(patient.getId());
	}

	@Ignore
	public void validateSearchResultsAreLimitedTo20() {
		Patient prototype = new Patient();
		prototype.setLastName("Patient26");
		Patients patients = patientResource.patientSearch(prototype);
		assertEquals(20, patients.size());
	}
}
