package com.agilex.healthcare.mobilehealthplatform.restservice.patients;

import static org.junit.Assert.assertEquals;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;

public class PatientDispalyNameTest {
	private String baseUri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();
	private String patientSearchURI = baseUri + "/patients";

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void setup() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if (client != null){
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void validatePatientDisplayName() {
		String searchCriteria = IntegrationTestConfiguration.getTestPatient().getLastName();
		String expectedDisplayName = IntegrationTestConfiguration.getTestPatient().getDisplayName();
		runTest(searchCriteria, expectedDisplayName);
	}

	@Test
	public void validatePatientDisplayNameOnPatientWithoutMiddleName() {
		String searchCriteria = "patient26,zztest17";
		String expectedDisplayName = "patient26, zztest17";
		runTest(searchCriteria, expectedDisplayName);
	}

	private void runTest(String searchCriteria, String expectedDisplayName) {
		String searchUri = patientSearchURI + "?searchstring=" + searchCriteria;
		Document result = client.getAsXml(searchUri);
		String displayName = XpathHelper.getString(result, "//m:patients/m:patient/displayName");
		assertEquals(expectedDisplayName.toLowerCase(), displayName.toLowerCase());
	}

}
