package com.agilex.healthcare.mobilehealthplatform.restservice.patients;

import static org.junit.Assert.assertTrue;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.XpathHelper;

public class PatientAgeTest {
	private String baseUri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();
	private String patientSearchURI = baseUri + "/patients";

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void setup() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if (client!=null){
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void verifyPatientAgeReturned() {
		String searchCriteria = IntegrationTestConfiguration.getTestPatient().getLastName();
		Node patient = getPatient(searchCriteria);
		String age = XpathHelper.getString(patient, "age");
		assertTrue(!isBlankAge(age)) ;
	}

	private boolean isBlankAge(String age) {
		if (NullChecker.isNullish(age))
			return true;
		else if (age.contentEquals("0"))
			return true;
		else
			return false;
	}

	private Node getPatient(String searchCriteria) {
		String searchUri = patientSearchURI + "?searchstring=" + searchCriteria;
		Document patients = client.getAsXml(searchUri);
		return XpathHelper.getNode(patients, "/m:patients/m:patient");
	}

}
