package com.agilex.healthcare.mobilehealthplatform.restservice.patients;

import static org.junit.Assert.assertEquals;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;


public class InpatientAdditionalDataTest {
	private String baseUri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();
	private String patientSearchURI = baseUri + "/patients";

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void validateMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if(client != null){
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void validateInpatientStatus() {
		String searchCriteria = IntegrationTestConfiguration.getTestInpatient().getSsn();
		String searchUri = patientSearchURI + "?searchstring=" + searchCriteria;
		Document result = client.getAsXml(searchUri);
		String inpatientFlag = XpathHelper.getString(result, "//m:patients/m:patient/inpatient");
		assertEquals("true", inpatientFlag);
	}
}
