package com.agilex.healthcare.mobilehealthplatform.restservice.patient.problems;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientDataResourceFieldTestRunner;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientProblemsXmlTest {
	private final static Problem testProblem = IntegrationTestConfiguration.getProblem();
	private static PatientDataResourceFieldTestRunner runner = null;

	@BeforeClass
	public static void setup() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		runner = createProblemTestRunner(testProblem);
	}
	
	@AfterClass
	public static void teardown() {
		runner = null;
	}

	private static PatientDataResourceFieldTestRunner createProblemTestRunner(Problem testProblem) {
		String xpathOnPatientsToDataLink = "//m:patient/atom:link[@title='patient-problems']";
		String xpathOnRetrieveToDataList = "//m:problems/m:problem";
		String xpathOnDataListToTestDataElement = "";
		return new PatientDataResourceFieldTestRunner(testProblem.getPatientId(), xpathOnPatientsToDataLink, xpathOnRetrieveToDataList, xpathOnDataListToTestDataElement);
	}

	@Test
	public void validateDescription() {
		runner.validateFieldTest(testProblem.getDescription(), "@description");
	}

	@Test
	public void validateOnsetDate() {
		runner.validateFieldTest(testProblem.getOnsetDate(), "MM/dd/yyyy", "@onsetDate");
	}

	@Test
	public void validateActive() {
		runner.validateFieldTest(testProblem.isActive(), "@active");
	}

	@Test
	public void ensureAtleastReturned() {
		runner.validateAtleastCountTest(1);
	}

	@Test
	public void noResultsTest() {
		runner.noDataReturnedTest();
	}

}
