package com.agilex.healthcare.mobilehealthplatform.restservice.patient.problems;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientProblemsResourceTest {
	
	private static Patient testPatient;

	URI problemUri = null;

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void validateMode() {
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
        if(client != null){
            client.getJerseyClient().destroy();
            client = null;
        }
	}
	
	@Before
	public void setup() {
		testPatient = PatientLoader.loadTestPatient();
		this.problemUri = testPatient.getProblemsUri();
	}


	@Test
	public void verifyFetchProblemsById() {
		Problems problems = client.getJerseyClient().resource(this.problemUri).get(Problems.class);
		assertNotNull(problems);
	}

	@Test
	public void verifyFetchProblemsByDates() {		
		URI uriWithFilter = UriBuilder.fromUri(this.problemUri).queryParam("startDate", "01/01/2000").queryParam("endDate", "12/28/2010").build();
		Problems problems = client.getJerseyClient().resource(uriWithFilter).get(Problems.class);
		assertTrue(problems.size() > 1);
	}

	@Test
	public void verifySortOrder() {		
		URI uriWithFilter = UriBuilder.fromUri(this.problemUri).build();
		Problems problems = client.getJerseyClient().resource(uriWithFilter).get(Problems.class);

		assertNotNull(problems);
		
		String problem1;
		String problem2;
		
		for(int i = 0; i < problems.getSize() -1; i++)
		{
			problem1 = problems.get(i).getDescription().toLowerCase();
			problem2 = problems.get(i + 1).getDescription().toLowerCase();
			assertTrue(problem1.toLowerCase().compareTo(problem2.toLowerCase()) <= 0);
		}
	}
}
