package com.agilex.healthcare.mobilehealthplatform.restservice.patient.labresults;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.XpathHelper;

public class LabXmlSmokeTest {
	private String labTestHistoryLink = getLabTestHistoryLink();
	private String labResultLink = getLabResultsLink();


	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void validateMode() {
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
        if(client !=null ){
            client.getJerseyClient().destroy();
            client = null;
        }
	}
	
	private String getLabTestHistoryLink() {
		Patient patient = PatientLoader.loadTestLabPatient();
		Document patientXml = client.getAsXml(patient.getSelfUri());
		return XpathHelper.getString(patientXml, "//m:patient/atom:link[@title='patient-lab-tests']/@href");
	}

	private String getLabResultsLink() {
		Patient patient = PatientLoader.loadTestLabPatient();
		Document patientXml = client.getAsXml(patient.getSelfUri());
		return XpathHelper.getString(patientXml, "//m:patient/atom:link[@title='patient-lab-results']/@href");
	}

	@Test
	public void patientHasLabTestResultLink() {
		assertTrue(NullChecker.isNotNullish(labResultLink));
	}

	@Test
	public void patientHasLabTestHistoryLink() {
		assertTrue(NullChecker.isNotNullish(labTestHistoryLink));
	}

	@Test
	public void ableToInvokeLabTestHistory() {
		Document result = client.getAsXml(labTestHistoryLink);
		assertNotNull(result);
	}
	@Test
	public void ableToInvokeLabResults() {
		Document result = client.getAsXml(labResultLink);
		assertNotNull(result);
	}

}
