package com.agilex.healthcare.mobilehealthplatform.restservice.patient.labresults;

import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.restservice.GeneralResourceTestBase;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.utility.ModeHelper;

public class LabTestsResourceTest extends GeneralResourceTestBase {
	String uri = null;

    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Before
	public void setup() {
		Patient patient = PatientLoader.loadTestLabPatient();
		this.uri = patient.getLabTestHistoryUri().toString();
	}

	@Override
	protected String getResourcePath() {
		return this.uri;
	}
}
