package com.agilex.healthcare.mobilehealthplatform.restservice.patient.labresults;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.XpathHelper;

@Ignore
public class LabTestHistoryXmlTest {
	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void validateMode() {
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		client.getJerseyClient().destroy();
		client = null;
	}
	
	private Document getLabTestsForAPatient() {
		Patient patient = PatientLoader.loadTestLabPatient();
		Document patientXml = client.getAsXml(patient.getSelfUri());
		String labTestsForAPatientLink = XpathHelper.getString(patientXml, "//m:patient/atom:link[@title='patient-lab-tests']/@href");
		return client.getAsXml(labTestsForAPatientLink);
	}

	@Test
	public void labTestsHasData() {
		Document result = getLabTestsForAPatient();
		assertNotNull(result);
		NodeList tests = XpathHelper.getNodeList(result, "/m:labTests/m:labTest");
		assertTrue(tests.getLength() >= 1);
	}

	@Test
	public void labTestsHasSelfLink() {
		Document result = getLabTestsForAPatient();
		String selfLink = XpathHelper.getString(result, "/m:labTests/atom:link[@rel='self']/@href");
		assertTrue(NullChecker.isNotNullish(selfLink));
	}

	@Test
	public void testEntryContainsLinkToAllResultsForThatTest() {
		String testId = IntegrationTestConfiguration.getLabPatientTestLab1().getTestId();
		Document result = getLabTestsForAPatient();
		String selflink = XpathHelper.getString(result, "//m:labTests/m:labTest[@id=" + testId + "]/atom:link[@rel='related'][@title='patient-lab-results-fortest']/@href");
		assertTrue(NullChecker.isNotNullish(selflink));
	}

	@Test
	public void testEntryExistsExactlyOneTime() {
		String testId = IntegrationTestConfiguration.getLabPatientTestLab1().getTestId();
		String specimenId = IntegrationTestConfiguration.getLabPatientTestLab1().getSpecimenId();
		
		String count = XpathHelper.getString(getLabTestsForAPatient(), "count(//m:labTests/m:labTest[@id=" + testId + "][@specimenId=" + specimenId+ "])");
		assertEquals(String.format("Expected test %s to show up exactly one time in result.", testId), "1", count);
	}

	@Test
	public void labTestEntryContainsTestName() {
		String testId = IntegrationTestConfiguration.getLabPatientTestLab1().getTestId();
		String specimenId = IntegrationTestConfiguration.getLabPatientTestLab1().getSpecimenId();
		
		String testname = XpathHelper.getString(getLabTestsForAPatient(), "//m:labTests/m:labTest[@id=" + testId + "][@specimenId=" + specimenId+ "]/@testname");

		assertEquals(IntegrationTestConfiguration.getLabPatientTestLab1().getTestname() + " (" + IntegrationTestConfiguration.getLabPatientTestLab1().getSpecimenName() + ")" , testname);
	}

	@Test
	public void testEntry2ExistsExactlyOneTime() {
		String testId = IntegrationTestConfiguration.getLabPatientTestLab2().getTestId();
		String count = XpathHelper.getString(getLabTestsForAPatient(), "count(//m:labTests/m:labTest[@id=" + testId + "])");
		assertEquals(String.format("Expected test %s to show up exactly one time in result.", testId), "1", count);
	}

	private void runAttributeTest(String attributeName, String expectedAttributeValue) {
		String testId = IntegrationTestConfiguration.getLabPatientTestLab1().getTestId();
		runAttributeTest(testId, attributeName, expectedAttributeValue);
	}

	private void runAttributeTest(String testId, String attributeName, String expectedAttributeValue) {
		Node testEntry = XpathHelper.getNode(getLabTestsForAPatient(), "//m:labTests/m:labTest[@id=" + testId + "]/m:labResult");
		String attributeValue = XpathHelper.getString(testEntry, attributeName);
		assertEquals(expectedAttributeValue, attributeValue);
	}

	@Test
	public void testEntryContainsValue() {
		String attributeName = "@value";
		String expectedAttributeValue = IntegrationTestConfiguration.getLabPatientTestLab1().getValue();
		runAttributeTest(attributeName, expectedAttributeValue);
	}

	@Test
	public void testEntryContainsTestId() {
		String attributeName = "@testId";
		String expectedAttributeValue = IntegrationTestConfiguration.getLabPatientTestLab1().getTestId();
		runAttributeTest(attributeName, expectedAttributeValue);
	}

	@Test
	public void testEntryContainsTestName() {
		String attributeName = "@testname";
		String expectedAttributeValue = IntegrationTestConfiguration.getLabPatientTestLab1().getTestname();
		runAttributeTest(attributeName, expectedAttributeValue);
	}

	@Ignore
	public void testEntryContainsResultedDate() {
		String attributeName = "@resultedDate";
		String expectedAttributeValue = DateHelper.formatDateTime(IntegrationTestConfiguration.getLabPatientTestLab1().getResultedDate());
		runAttributeTest(attributeName, expectedAttributeValue);
	}

	@Test
	public void testEntryContainsIndicator() {
		String attributeName = "@indicator";
		String expectedAttributeValue = IntegrationTestConfiguration.getLabPatientTestLab1().getIndicator();
		runAttributeTest(attributeName, expectedAttributeValue);
	}

	@Test
	public void testEntryContainsIndicatorFlag() {
		String attributeName = "@abnormalIndicatorFlag";
		String expectedAttributeValue = Boolean.toString(IntegrationTestConfiguration.getLabPatientTestLab1().isAbnormalIndicatorFlag());
		runAttributeTest(attributeName, expectedAttributeValue);
	}

	@Test
	public void testEntryContainsReferenceLow() {
		String attributeName = "@referenceLow";
		String expectedAttributeValue = IntegrationTestConfiguration.getLabPatientTestLab1().getReferenceLow();
		runAttributeTest(attributeName, expectedAttributeValue);
	}

	@Test
	public void testEntryContainsReferenceHigh() {
		String attributeName = "@referenceHigh";
		String expectedAttributeValue = IntegrationTestConfiguration.getLabPatientTestLab1().getReferenceHigh();
		runAttributeTest(attributeName, expectedAttributeValue);
	}

	@Test
	public void testEntryContainsValueUnits() {
		String attributeName = "@valueUnits";
		String expectedAttributeValue = IntegrationTestConfiguration.getLabPatientTestLab1().getValueUnits();
		runAttributeTest(attributeName, expectedAttributeValue);
	}
}
