package com.agilex.healthcare.mobilehealthplatform.restservice.patient.labresults;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;

@Ignore
public class LabTestGroupsTest {
/*
	private static PatientResourceClient patientResource = null;

	@BeforeClass
	public static void setup() {
		MobileHealthClientTestVersion mobileHealthClient = TestHelper.createMobileHealthClient();
		patientResource = mobileHealthClient.getPatientResourceClient();
		assertNotNull(patientResource);
	}
*/
	@Test
	public void patientContainsLinkToLabTestGroup() {
		Patient patient = PatientLoader.loadTestLabPatientWithGroups();
		assertNotNull(patient.getLabTestHistoryByGroupUri());
	}

	@Test
	public void retrieveLabTestGroup() {
		Client client = TestHelper.createJerseyClient();
		NodeList groups = getLabTestsByGroupAsNodeList(client, IntegrationTestConfiguration.getLabPatientWithGroups().getId(), "zztest.patient01");
		client.destroy();
		assertTrue(groups.getLength() >= 1);
	}

	@Test
	public void retrieveLabTestGroupForPatientWithoutData() {

		AuthenticationInfo authenticationInfo = new AuthenticationInfo("zztest.patient76", "pass", "oauth");
		MobileHealthClientTestVersion noDataClient = TestHelper.createMobileHealthClient(authenticationInfo);
		
		PatientIdentifier patientIdentifer = new PatientIdentifier("EDIPI", "NO-DATA-MOCK");
		
		NodeList groups = getLabTestsByGroupAsNodeList(noDataClient.getJerseyClient(), patientIdentifer.getUniqueId(), "zztest.patient76");
		
		noDataClient.getJerseyClient().destroy();
		assertEquals(0, groups.getLength());
	}
	
	@Test
	public void verifyTestDescriptionExists() {
		MobileHealthClientTestVersion mobileHealthClient = TestHelper.createMobileHealthClient("zztest.patient01", "pass", "oauth");
		Document labTestByGroups = getLabTestsByGroup(mobileHealthClient.getJerseyClient(), IntegrationTestConfiguration.getTestPatient().getId(), "zztest.patient01");
		String retrievedTestDescription = XpathHelper.getString(labTestByGroups, "//m:labTestGroups/m:labTestGroup/m:labTest[1]/@testDescription");
		mobileHealthClient.getJerseyClient().destroy();
		assertNotNull(retrievedTestDescription);
	}
	
	private NodeList getLabTestsByGroupAsNodeList(Client jerseyClient, String patientId, String userName) {
		Document labTestsByGroup = getLabTestsByGroup(jerseyClient, patientId, userName);
		assertNotNull(labTestsByGroup);
		NodeList groups = XpathHelper.getNodeList(labTestsByGroup, "//m:labTestGroups/m:labTestGroup");
		return groups;
	}

	private Document getLabTestsByGroup(Client jerseyClient, String patientId, String userName) {
		Patient patient = PatientLoader.loadPatient(new PatientIdentifier("EDIPI", patientId), userName);
		URI uri = patient.getLabTestHistoryByGroupUri();
		Document labTestsByGroup = jerseyClient.resource(uri).get(Document.class);
		return labTestsByGroup;
	}
}
