package com.agilex.healthcare.mobilehealthplatform.restservice.patient.labresults;

import static org.junit.Assert.fail;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.XpathHelper;

public class LabResultRetriever {
	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void validateMode() {
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		client.getJerseyClient().destroy();
		client = null;
	}
	
	
	private static Document getLabTestsForAPatient(Patient patient) {
		Document patientXml = client.getAsXml(patient.getSelfUri());
		String labTestsForAPatientLink = XpathHelper.getString(patientXml, "//m:patient/atom:link[@title='patient-lab-tests']/@href");
		return client.getAsXml(labTestsForAPatientLink);
	}

	private static Node getLabResultByAccessionNumber(Patient patient, String testId, String accessionNumber) {
		Document labTestsForPatient = getLabTestsForAPatient(patient);
		String uriForResults = XpathHelper.getString(labTestsForPatient, String.format("//m:labTests/m:labTest[@id='%s']/atom:link[@title='patient-lab-results-fortest']/@href", testId));
		Document labResults = client.getAsXml(uriForResults);
		Node labResult = XpathHelper.getNode(labResults, String.format("//m:labResults/m:labResult[@accessionNumber='%s']", accessionNumber));
		return labResult;
	}

	private static Node getLabResultByOrderIdAndTestId(Patient patient, String testId, String orderId) {
		Document labTestsForPatient = getLabTestsForAPatient(patient);
		String uriForResults = XpathHelper.getString(labTestsForPatient, String.format("//m:labTests/m:labTest[@id='%s']/atom:link[@title='patient-lab-results-fortest']/@href", testId));
		Document labResults = client.getAsXml(uriForResults);
		String xpath = String.format("//m:labResults/m:labResult[@orderId='%s'][@testId='%s']", orderId, testId);
		NodeList labResultsMeetingXpath = XpathHelper.getNodeList(labResults, xpath);
		if (labResultsMeetingXpath.getLength() > 1)
			fail(String.format("These test make the assumption that patient/order/test are unique, but multiple results were returned for this combination. [%s][%s][%s]", patient.getId(), orderId,
					testId));
		Node labResult = labResultsMeetingXpath.item(0);
		return labResult;
	}

	public static Node getLabResultsForPatient(Patient patient, LabResult expectedLabResult) {
		Node labResult = null;
		if (NullChecker.isNotNullish(expectedLabResult.getAccessionNumber()))
			labResult = getLabResultByAccessionNumber(patient, expectedLabResult.getTestId(), expectedLabResult.getAccessionNumber());
		if (labResult == null)
			labResult = getLabResultByOrderIdAndTestId(patient, expectedLabResult.getTestId(), expectedLabResult.getOrderId());
		return labResult;
	}
}
