package com.agilex.healthcare.mobilehealthplatform.restservice.patient.labresults;

import static org.junit.Assert.assertEquals;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.DateHelper;

@Ignore
public class LabResultAbnormalityFlagTest {
	private static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(LabResultAbnormalityFlagTest.class);

	// @Test
	// public void outputCalculations() {
	// MobileHealthClientTestVersion client =
	// TestHelper.createMobileHealthClient();
	// Patient patient = PatientLoader.loadTestLabPatient();
	// patient =
	// client.getJerseyClient().resource(patient.getSelfUri()).get(Patient.class);
	// LabResults labResults =
	// client.getJerseyClient().resource(patient.getLabResultsUri()).get(LabResults.class);
	// assertNotNull(labResults);
	//
	// System.out
	// .println("labResult.getValue() , labResult.getReferenceLow() , labResult.getReferenceHigh() ,labResult.getIndicator() , labResult.isAbnormalIndicatorFlag(), labResult.getAbnormalIndicatorTriFlag()");
	// for (LabResult labResult : labResults) {
	// System.out.println(String.format("%s,%s,%s,%s,%s,%s",
	// labResult.getValue(), labResult.getReferenceLow(),
	// labResult.getReferenceHigh(), labResult.getIndicator(),
	// labResult.isAbnormalIndicatorFlag(),
	// labResult.getAbnormalIndicatorTriFlag()));
	// }
	// }

	@Test
	public void ensureAbnormalResultIndicatorSet() {
		Patient patient = PatientLoader.loadTestLabPatient();
		LabResult expectedLabResult = IntegrationTestConfiguration.getLabPatientTestLabAbnormal();
		LabResult retrievedLabResult = retrieveLab(patient, expectedLabResult);
		assertEquals(expectedLabResult.getIndicator(), retrievedLabResult.getIndicator());
	}

	private LabResult retrieveLab(Patient patient, LabResult expectedLabResult) {
		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient();
		patient = client.getJerseyClient().resource(patient.getSelfUri()).get(Patient.class);
		LabResults labResults = client.getJerseyClient().resource(patient.getLabResultsUri()).get(LabResults.class);
		logger.debug(String.format("retrieved %s results", labResults.size()));

		logger.debug(String.format("looking for match by testid and resultedDate [%s][%s]", expectedLabResult.getTestId(), expectedLabResult.getResultedDate()));
		LabResult retrievedLabResult = null;
		for (LabResult potentialMatch : labResults) {
			logger.debug(String.format("checking for match expected:[%s][%s];potentialMatch:[%s][%s]", expectedLabResult.getTestId(), expectedLabResult.getResultedDate(), potentialMatch.getTestId(),
					potentialMatch.getResultedDate()));
			if (potentialMatch.getTestId().contentEquals(expectedLabResult.getTestId()) && DateHelper.areEqual(potentialMatch.getResultedDate(), expectedLabResult.getResultedDate()))
				retrievedLabResult = potentialMatch;
		}
		client.getJerseyClient().destroy();
		return retrievedLabResult;
	}

	@Test
	public void ensureAbnormalResultAbnormalityFlagSet() {
		Patient patient = PatientLoader.loadTestLabPatient();
		LabResult expectedLabResult = IntegrationTestConfiguration.getLabPatientTestLabAbnormal();
		LabResult retrievedLabResult = retrieveLab(patient, expectedLabResult);
		assertEquals(expectedLabResult.isAbnormalIndicatorFlag(), retrievedLabResult.isAbnormalIndicatorFlag());
	}


}
