package com.agilex.healthcare.mobilehealthplatform.restservice.patient.labresults;

import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class LabLinksTest {

	private Patient retrievedPatient;

    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Before
	public void setup() {
		Patient patient = PatientLoader.loadTestLabPatient();
		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient();
		retrievedPatient = client.getJerseyClient().resource(patient.getSelfUri()).get(Patient.class);
		client.getJerseyClient().destroy();
	}

	@Test
	public void patientHasChemLabGroupLink() {
		URI chemistryUri = retrievedPatient.getLabTestHistoryByGroupUri();
		assertTrue("Invalid link: " + chemistryUri, chemistryUri.toString().contains("/lab/group"));
	}

	@Test
	public void patientHasChemLabResultsLink() {
		URI chemistryUri = retrievedPatient.getLabResultsUri();
		assertTrue("Invalid link: " + chemistryUri, chemistryUri.toString().contains("/lab/results"));
	}

	@Test
	public void patientHasMicroLabGroupLink() {
		URI microUri = retrievedPatient.getMicroLabTestHistoryByGroupUri();
		assertTrue("Invalid link: " + microUri, microUri.toString().contains("/lab-microbiology/group"));
	}

	@Test
	public void patientHasMicroLabResultsLink() {
		URI microUri = retrievedPatient.getMicroLabResultsUri();
		assertTrue("Invalid link: " + microUri, microUri.toString().contains("/lab-microbiology/results"));
	}

}
