package com.agilex.healthcare.mobilehealthplatform.restservice.patient.labresults;

import static org.junit.Assert.fail;

import java.util.HashSet;
import java.util.Set;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;


public class ChemistryLabResourceTest {
	
    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Test
	public void testRetrieveChemistryLab() {
		Patient seededPatient = PatientLoader.loadTestLabPatient();
		LabResult expectedLabResult = IntegrationTestConfiguration.getLabPatientTestLabNormal();
		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient();
		seededPatient = client.getJerseyClient().resource(seededPatient.getSelfUri()).get(Patient.class);
		LabResults labResults = client.getJerseyClient().resource(seededPatient.getLabResultsUri()).get(LabResults.class);

		client.getJerseyClient().destroy();
		
		Set<String> setTestId = new HashSet<String>();
		for (LabResult potentialMatch : labResults) {
			setTestId.add(potentialMatch.getTestId());
		}
		// looking for test id in the retrieved list
		if (setTestId.contains(expectedLabResult.getTestId()))
			assert(true);
		else
			fail("Could not find the Test Id in seeded test data.");
	}

}
