package com.agilex.healthcare.mobilehealthplatform.restservice.patient.lab.micro;

import static org.junit.Assert.assertTrue;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;


public class MicrobiologyLabResourceTest {
	
    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev, dev"));
    }
    
	@Test
	public void testRetrieveMicrobiologyLab() {
		Patient seededPatient = PatientLoader.loadTestLabPatient();
		//LabResult expectedLabResult = IntegrationTestConfiguration.getLabPatientTestLabNormal();
		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient();
		seededPatient = client.getJerseyClient().resource(seededPatient.getSelfUri()).get(Patient.class);
		LabResults labResults = client.getJerseyClient().resource(seededPatient.getMicroLabResultsUri()).get(LabResults.class);

		client.getJerseyClient().destroy();
		
		assertTrue(labResults.size() >= 7);
		assertTrue(labResults.get(0).getSpecimenId().trim().equals("70"));
	}

}
