package com.agilex.healthcare.mobilehealthplatform.restservice.patient.lab.micro;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTest;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTests;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.NullChecker;

public class MicroLabResourceTest {
	Patient patient = PatientLoader.loadTestLabPatient();

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void validateMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
        if(client != null){
            client.getJerseyClient().destroy();
            client = null;
        }
	}

	@Test
	public void fetchMicroTests() {
		URI microTestsUri = patient.getLink().getUriByTitle(LinkTitles.PatientMicrobiologyLabTestHistory);
		LabTests labTests = client.getJerseyClient().resource(microTestsUri).get(LabTests.class);
		assertNotNull(labTests);
		assertTrue("No micro labs for patient " + patient.getPatientIdentifier(), labTests.size() > 0);
	}

	@Test
	public void fetchSingleMicro() {
		URI uriForResult = getUriForSingleResult();
		assertNotNull(uriForResult);
		LabResult singleResultRetrievedFromServer = client.getJerseyClient().resource(uriForResult).get(LabResult.class);
		assertTrue(NullChecker.isNotNullish(singleResultRetrievedFromServer.getValue()));
	}

	private URI getUriForSingleResult() {
		URI microTestsUri = patient.getLink().getUriByTitle(LinkTitles.PatientMicrobiologyLabTestHistory);
		LabTests labTests = client.getJerseyClient().resource(microTestsUri).get(LabTests.class);
		LabTest labTest = labTests.get(0);
		LabResult singleResult = labTest.getLabResults().get(0);
		URI uriForResult = singleResult.getSelfUri();
		return uriForResult;
	}
}
