package com.agilex.healthcare.mobilehealthplatform.restservice.patient.demographics;

import static org.junit.Assert.*;

import java.net.URI;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.clientapi.*;
import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.testutility.*;
import com.agilex.healthcare.utility.*;
import com.sun.jersey.api.client.UniformInterfaceException;

public class PatientDemographicsViaApiTest {
	MobileHealthClientTestVersion mobileHealthClient;
	private PatientResourceClient patientResourceClient = null;

    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Before
	public void setup() {
		mobileHealthClient = TestHelper.createMobileHealthClient();
		patientResourceClient = mobileHealthClient.getPatientResourceClient();
	}

	@After
	public void teardown() {
		mobileHealthClient.getJerseyClient().destroy();
		mobileHealthClient = null;
		patientResourceClient = null;
	}
	
	@Test
	public void validatePatientSearchResultsContainDemographicsDataLink() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		Patients patients = TestHelper.getTestPatientSearchResults();
		for (Patient patient : patients) { 
			assertNotNull(patient.getDemographicsUri());
		}
	}

	@Test
	public void validatePatientRetrieveContainDemographicsDataLink() {
		Patient patient = PatientLoader.loadTestPatient();
		assertNotNull(patient.getDemographicsUri());
	}

	@Test
	public void validateRetrieveDemographicsDataByPatientIsNotNull() {
		Patient patient = PatientLoader.loadTestPatient();
		PatientDemographics DemographicsData = patientResourceClient.getDemographics(patient);
		assertNotNull(DemographicsData);
	}

	@Test
	public void validateRetrieveDemographicsDataByUriIsNotNull() {
		URI uri = getDemographicDataLinkForPatientWithData();
		PatientDemographics DemographicsData = patientResourceClient.getDemographics(uri);
		assertNotNull(DemographicsData);
	}

	@Ignore
	public void validateRetrieveDemographicsDataContainsNextOfKin() {
		URI uri = getDemographicDataLinkForPatientWithData();
		PatientDemographics DemographicsData = patientResourceClient.getDemographics(uri);
		assertNotNull(DemographicsData.getNextOfKin());
		assertTrue(NullChecker.isNotNullish(DemographicsData.getNextOfKin().getName()));
	}

	@Test(expected = UniformInterfaceException.class)
	public void validateRetrieveDemographicsDataByInvalidPatientResultsIn404() {
		URI validUri = getDemographicDataLinkForPatientWithData();
		URI invalidUri = URI.create(validUri.toString().replace(IntegrationTestConfiguration.getTestPatient().getId(), "invalidPatientId"));
		patientResourceClient.getDemographics(invalidUri);
		fail("Should have errorred before getting here.");
	}
	
	@Test
	public void validateRetrieveDemographicsDataContainsSelfLink() {
		URI uri = getDemographicDataLinkForPatientWithData();
		PatientDemographics DemographicsData = patientResourceClient.getDemographics(uri);
		AtomLink link = DemographicsData.getSelfLink();
		assertNotNull(link);
	}

	private URI getDemographicDataLinkForPatientWithData() {
		Patient patient = PatientLoader.loadTestPatient();
		URI DemographicsDataUri = patient.getDemographicsUri();
		return DemographicsDataUri;
	}

}
