package com.agilex.healthcare.mobilehealthplatform.restservice.patient.demographics;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.XpathHelper;
@Ignore
public class PatientDemographicsNextOfKinViaXmlTest {
	private MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient();

	@Test
	public void getDemographics() {
		URI uri = PatientLoader.loadTestPatient().getDemographicsUri();
		Document demographics = client.getAsXml(uri);
		assertNotNull(demographics);
	}

	@Test
	public void getDemographicsContainsNextOfKin() {
		URI uri = PatientLoader.loadTestPatient().getDemographicsUri();
		Document demographics = client.getAsXml(uri);
		Node nextOfKin = XpathHelper.getNode(demographics, "/m:demographics/m:nextOfKin");
		assertNotNull(nextOfKin);
	}

	@Test
	public void getDemographicsContainsNextOfKinName() {
		URI uri = PatientLoader.loadTestPatient().getDemographicsUri();
		Document demographics = client.getAsXml(uri);
		String value = XpathHelper.getString(demographics, "/m:demographics/m:nextOfKin/@name");
		assertTrue(NullChecker.isNotNullish(value));
	}
	@Test
	public void getDemographicsContainsNextOfKinPhone() {
		URI uri = PatientLoader.loadTestPatient().getDemographicsUri();
		Document demographics = client.getAsXml(uri);
		String value = XpathHelper.getString(demographics, "/m:demographics/m:nextOfKin/@phoneNumber");
		assertTrue(NullChecker.isNotNullish(value));
	}
	@Test
	public void getDemographicsContainsNextOfKinRelationship() {
		URI uri = PatientLoader.loadTestPatient().getDemographicsUri();
		Document demographics = client.getAsXml(uri);
		String value = XpathHelper.getString(demographics, "/m:demographics/m:nextOfKin/@relationship");
		assertTrue(NullChecker.isNotNullish(value));
	}

	@Test
	public void getDemographicsForPatientWithoutNextOfKinDoesNotHaveNextOfKinElement() {
		URI uri = PatientLoader.loadTestPatientWithNoData().getDemographicsUri();
		Document demographics = client.getAsXml(uri);
		Node nextOfKin = XpathHelper.getNode(demographics, "/m:demographics/m:nextOfKin");
		assertNull(nextOfKin);
	}
}
