package com.agilex.healthcare.mobilehealthplatform.restservice.patient.demographics;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;

import java.net.URI;

import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;

@Ignore
public class PatientAddressViaXmlTest {
	@Test
	public void retrieveAddressContainsData() {
		Node addressNode = getAddress();
		assertNotNull(addressNode);
	}

	@Test
	public void retrieveAddressContainsCity() {
		String expectedValue = "Chantilly";
		String attributeName = "@city";
		runTest(attributeName, expectedValue);
	}

	@Test
	public void retrieveAddressContainsState() {
		String expectedValue = "virginia";
		String attributeName = "@state";
		runTest(attributeName, expectedValue);
	}

	@Test
	public void retrieveAddressContainsAddress1() {
		String expectedValue = "345 Tester Lane";
		String attributeName = "@streetAddressLine1";
		runTest(attributeName, expectedValue);
	}

	@Test
	public void retrieveAddressContainsAddress2() {
		String expectedValue = "Apt. 123";
		String attributeName = "@streetAddressLine2";
		runTest(attributeName, expectedValue);
	}

	@Test
	public void retrieveAddressContainsAddress3() {
		String expectedValue = "P.O. BOX 1234";
		String attributeName = "@streetAddressLine3";
		runTest(attributeName, expectedValue);
	}

	@Test
	public void retrieveAddressContainsDisplayLine1() {
		String expectedValue = "345 Tester Lane, Apt. 123, P.O. BOX 1234";
		String attributeName = "@formattedDisplayAddress1";
		runTest(attributeName, expectedValue);
	}

	@Test
	public void retrieveAddressContainsDisplayLine2() {
		String expectedValue = "Chantilly, virginia 20151";
		String attributeName = "@formattedDisplayAddress2";
		runTest(attributeName, expectedValue);
	}

	private void runTest(String attributeName, String expectedValue) {
		Node addressNode = getAddress();
		String attributeValue = XpathHelper.getString(addressNode, attributeName);
		assertEquals(expectedValue.toLowerCase(), attributeValue.toLowerCase());
	}

	private Node getAddress() {
		Patient p = PatientLoader.loadTestPatient();
		URI demographicsLinkuri = p.getDemographicsUri();
		Client client = TestHelper.createJerseyClient();
		Document xml = client.resource(demographicsLinkuri).get(Document.class);
		Node addressNode = XpathHelper.getNode(xml, "//m:demographics/m:address");
		return addressNode;
	}

	@Test
	public void addressNullForPatientWithoutAddress() {
		Patient p = PatientLoader.loadTestPatientWithNoData();
		URI demographicsLinkuri = p.getDemographicsUri();
		Client client = TestHelper.createJerseyClient();
		Document xml = client.resource(demographicsLinkuri).get(Document.class);
		Node addressNode = XpathHelper.getNode(xml, "//m:demographics/m:address");
		assertNull("Expect that patient demographics with no address [" + demographicsLinkuri.toString() + "] will have null address element.", addressNode);
	}
}
