package com.agilex.healthcare.mobilehealthplatform.restservice.patient.allergy;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URI;

import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.NullCheckerAssert;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientAllergyViaApi {
	private Allergy testAllergy;

    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Before
	public void setup() {
		testAllergy = IntegrationTestConfiguration.getTestAllergy();
		assertNotNull(testAllergy);
	}

	private Allergy getTestAllergy() {
		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient("zztest.patient01", "pass", "oauth");
		Patient patient = PatientLoader.loadPatient(new PatientIdentifier("EDIPI", testAllergy.getPatientId()),  "zztest.patient01");
		Allergies allergies = client.getPatientResourceClient().getPatientAllergies(patient);
		Allergy allergy = null;
		for (Allergy potentialMatch : allergies)
			if (testAllergy.getSubstance().contentEquals(potentialMatch.getSubstance())) {
				allergy = potentialMatch;
				break;
			}
		
		client.getJerseyClient().destroy();
		return allergy;
	}

	@Test
	public void retrieveAllergy() {
		Allergy allergy = getTestAllergy();
		assertNotNull(allergy);
	}

	@Ignore
	public void allergyHasSelfLink() {
		Allergy allergy = getTestAllergy();
		URI selfLink = allergy.getSelfUri();
		NullCheckerAssert.assertNotNullish(selfLink);
	}

	@Test
	public void allergyContainsSubstance() {
		Allergy allergy = getTestAllergy();
		assertNotNull(allergy.getSubstance());
		assertEquals(testAllergy.getSubstance().toLowerCase(), allergy.getSubstance().toLowerCase());
	}

	@Test
	public void allergyContainsReaction() {
		Allergy allergy = getTestAllergy();
		assertNotNull(allergy.getReaction());
		assertEquals(testAllergy.getReaction().toLowerCase(), allergy.getReaction().toLowerCase());
	}

	@Test
	public void allergyContainsSeverity() {
		Allergy allergy = getTestAllergy();
		assertNotNull(allergy.getSeverity());
		assertEquals(testAllergy.getSeverity().toLowerCase(), allergy.getSeverity().toLowerCase());
	}
}
