package com.agilex.healthcare.mobilehealthplatform.restservice.patient.allergy;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientDataResourceFieldTestRunner;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientAllergiesViaXmlTest {
	private static Allergy testAllergy = null;
	private static PatientDataResourceFieldTestRunner runner = null;

	@BeforeClass
	public static void setup() {
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		testAllergy = IntegrationTestConfiguration.getTestAllergy();
		runner = createAllergyTestRunner(testAllergy);
	}

	private static PatientDataResourceFieldTestRunner createAllergyTestRunner(Allergy testAllergy) {
		String xpathOnPatientsToDataLink = "//m:patient/atom:link[@title='patient-allergies']";
		String xpathOnRetrieveToDataList = String.format("//m:allergies/m:allergy");
		String xpathOnDataListToTestDataElement = String.format("[@substance='%s']", testAllergy.getSubstance());
		return new PatientDataResourceFieldTestRunner(testAllergy.getPatientId(), xpathOnPatientsToDataLink, xpathOnRetrieveToDataList, xpathOnDataListToTestDataElement);
	}

	@Test
	public void retrievePatientAllergiesNoError() {
		runner.retrieveData();
	}

	@Test
	public void ensureAtleastReturned() {
		runner.validateAtleastCountTest(1);
	}

	@Test
	public void noResultsTest() {
		runner.noDataReturnedTest();
	}

	@Test
	public void validateCategory() {
		runner.validateFieldTest(testAllergy.getCategory(), "@category");
	}

	@Test
	public void validateSubstance() {
		runner.validateFieldTest(testAllergy.getSubstance(), "@substance");
	}

	@Test
	public void validateNote() {
		runner.validateFieldTest(testAllergy.getNote(), "@note");
	}

	@Test
	public void validateOnsetDate() {
		runner.validateFieldTest(testAllergy.getOnsetDate(), "?", "@onsetDate");
	}

	@Test
	public void validateReaction() {
		runner.validateFieldTest(testAllergy.getReaction(), "@reaction");
	}

	@Test
	public void validateResolutionDate() {
		runner.validateFieldTest(testAllergy.getResolutionDate(), "?", "@resolutionDate");
	}

	@Test
	public void validateSeverity() {
		runner.validateFieldTest(testAllergy.getSeverity(), "@severity");
	}
}
