package com.agilex.healthcare.mobilehealthplatform.restservice.patient.allergy;

import java.net.URI;

import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.restservice.GeneralResourceTestBase;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientAllergiesResourceTest extends GeneralResourceTestBase {

	private URI allergiesUri;

    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-mode"));
    }
    
	@Before
	public void setup() {
		Patient patient = PatientLoader.loadTestPatient();
		allergiesUri = patient.getAllergiesUri();
	}

	@Override
	protected String getResourcePath() {
		return allergiesUri.toString();
	}
	
	@Test
	public void sample(){
		
	}
	

}
