package com.agilex.healthcare.mobilehealthplatform.restservice.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;

public class PatientTest {

    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Test
	public void retrievePatient() {
		Patient patient = PatientLoader.loadTestPatient();
		assertNotNull(patient);
	}

	@Ignore
	public void retrievePatientSsn() {
		Patient patient = PatientLoader.loadTestPatient();
		assertEquals("123-45-6789", patient.getSsn());
	}

	@Test
	public void retrievePatientContainsLastName() {
		Patient patient = PatientLoader.loadTestPatient();
		assertEquals("patient01", patient.getLastName().toLowerCase());
	}

	@Test
	public void retrievePatientContainsFirstName() {
		Patient patient = PatientLoader.loadTestPatient();
		assertEquals("zztest", patient.getFirstName().toLowerCase().substring(0,6));
	}

	@Ignore
	public void retrievePatientContainsDateOfBirth() {
		String expected = "May 05, 1900";
		Patient patient = PatientLoader.loadTestPatient();
		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient(); 
		Document patientXml = client.getAsXml(patient.getSelfUri().toString());
		String dob = XpathHelper.getString(patientXml, "/m:patient/@dateOfBirth");
		assertEquals(expected, dob);
		client.getJerseyClient().destroy();
	}
	
	@Ignore
	public void retrievePatientContainsAge() {
		String expected = "35";
		Patient patient = PatientLoader.loadTestPatient();
		MobileHealthClientTestVersion client = TestHelper.createMobileHealthClient();
		Document patientXml = client.getAsXml(patient.getSelfUri().toString());
		String dob = XpathHelper.getString(patientXml, "/m:patient/@age");
		assertEquals(expected, dob);
		client.getJerseyClient().destroy();
	}
}
