package com.agilex.healthcare.mobilehealthplatform.restservice.patient;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URI;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.restservice.GeneralResourceTestBase;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientResourceTest extends GeneralResourceTestBase {
	String patientUri = null;

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void validateMode() {
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		client = TestHelper.createMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
        if(client != null){
		    client.getJerseyClient().destroy();
		    client = null;
        }
	}

	@Before
	public void setup() {
		Patient patient = PatientLoader.loadTestPatient();
		this.patientUri = patient.getSelfUri().toString();
	}

	@Override
	protected String getResourcePath() {
		return patientUri;
	}
	
	@Test
	public void sample(){
		
	}
	
	@Test
	public void testInternalPatientDataStoreForDevMode() {
		Assume.assumeTrue(ModeHelper.isMode("dev"));
		
		URI uri = createInternalPatientUri("D123401");
		Patient patient = client.getJerseyClient().resource(uri).get(Patient.class);
		
		assertNotNull(patient);
		assertNotNull(patient.getFirstName());
		assertNotNull(patient.getLastName());
		assertNotNull(patient.isTextMessagingAllowed());
	}
	
	@Test
	public void testInternalPatientDataStoreForCihModes() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		
		try {
			URI uri = createInternalPatientUri("D123401");
			Patient patient = client.getJerseyClient().resource(uri).get(Patient.class);
			
			assertNotNull(patient);
			assertNotNull(patient.getFirstName());
			assertNotNull(patient.getLastName());
			assertNotNull(patient.isTextMessagingAllowed());
		} catch (WebApplicationException e) {
			assertEquals(404, e.getResponse().getStatus());
		}
	}

	private URI createInternalPatientUri(String patientId) {
		StringBuilder sb = new StringBuilder(IntegrationTestConfiguration.getMobileHealthServerBaseUri().toString());
		
		sb.append("/patient/EDIPI/");
		sb.append(patientId);
		
		return UriBuilder.fromUri(sb.toString()).build();
	}
}
