package com.agilex.healthcare.mobilehealthplatform.restservice.patient;

import static com.agilex.healthcare.testutility.NullCheckerAssert.assertNotNullish;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientLinkTest {
	
	@BeforeClass
	public static void setup(){
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
	}

	@Test
	public void validateLinksReturnedOnPatientSearch() {
		Patients patients = TestHelper.getTestPatientSearchResults();
		assertTrue(patients.size() > 0);
		for (Patient patient : patients)
			assertTrue(patient.getLink().size() > 0);
	}

	@Test
	public void validateLinksReturnedOnPatientRetrieve() {
		Patient patient = TestHelper.getProviderTestPatientViaDirectRetrieve();
		assertTrue(patient.getLink().size() > 0);
	}

	@Test
	public void validateSelfLinkOnPatientSearch() {
		Patients patients = TestHelper.getTestPatientSearchResults();
		for (Patient patient : patients)
			assertNotNullish(patient.getSelfUri());
	}

	@Test
	public void validateSelfLinkOnPatientRetrieve() {
		Patient patient = TestHelper.getProviderTestPatientViaDirectRetrieve();
		assertNotNullish(patient.getSelfUri());
	}

	@Test
	public void validateSelfLinkOnPatientSearchContainsPatientId() {
		Patients patients = TestHelper.getTestPatientSearchResults();
		for (Patient patient : patients) {
			String patientId = IntegrationTestConfiguration.getTestPatient().getId();
			URI link = patient.getSelfUri();
			assertNotNullish(link);
			assertTrue(link.getPath().contains(patientId));
		}
	}

	@Test
	public void validateSelfLinkOnPatientRetrieveContainsPatientId() {
		String patientId = IntegrationTestConfiguration.getTestPatient().getId();
		Patient patient = TestHelper.getProviderTestPatientViaDirectRetrieve();
		URI link = patient.getSelfUri();
		assertNotNullish(link);
		assertTrue(link.getPath().contains(patientId));
	}

}
