package com.agilex.healthcare.mobilehealthplatform.restservice.patient;

import static org.junit.Assert.assertNotNull;

import java.io.InputStream;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.clientapi.PatientResourceClient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;

@Ignore
public class PatientImageTest {
	private MobileHealthClientTestVersion client;
	private PatientResourceClient patientResourceClient = null;

	@Before
	public void setup() {
		client = TestHelper.createMobileHealthClient();
		patientResourceClient = client.getPatientResourceClient();
	}
	
	@After
	public void teardown() {
		client.getJerseyClient().destroy();
		client = null;
	}

	@Test
	public void checkPatientImageLinkReturnedOnPatientSearch() {
		Patient patient = getTestPatient();
		assertNotNull(patient.getPatientImageUri());
	}

	@Test
	public void checkPatientImageReturnedOnPatientWithImage() {
		Patient patient = getTestPatient();
		Object image = patientResourceClient.getPatientImage(patient);
		assertNotNull(image);
	}

	@Ignore
	public void checkPatientImageReturnedOnPatientWithoutImage() {
		// when image is not stored, a default image gets returned
		Patient patient = getPatientByLastName("Hutchinson");
		InputStream image = patientResourceClient.getPatientImage(patient);
		assertNotNull(image);
	}

	private Patient getPatientByLastName(String lastname) {
		Patient prototype = new Patient();
		prototype.setLastName(lastname);

		Patients patients = patientResourceClient.patientSearch(prototype);
		return patients.get(0);
	}

	private Patient getTestPatient() {
		return PatientLoader.loadTestPatient();
	}
}
