package com.agilex.healthcare.mobilehealthplatform.restservice.patient;

import static org.junit.Assert.assertEquals;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;


public class PatientDOBTest {
	private String patientSearchURI = IntegrationTestConfiguration.getMobileHealthServerBaseUri() + "/patients";

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void validateMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		client = TestHelper.createProviderMobileHealthClient();
	}

	@AfterClass
	public static void destroy() {
		if(client != null){
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void validatePatientContainsDateOfBirth() {
		Patient expectedPatient = IntegrationTestConfiguration.getPatientWithValidDOB();
		Document retrievedPatientXml = retrievePatient(expectedPatient.getFirstName(), expectedPatient.getLastName());
		String retrievedDOB = XpathHelper.getString(retrievedPatientXml, "//m:patients/m:patient/dateOfBirth");
		assertEquals(expectedPatient.getDateOfBirth().toString(), retrievedDOB);
	}

	@Test
	public void validatePatientContainsDateOfBirthWithMonthYearOnly() {
		Patient expectedPatient = IntegrationTestConfiguration.getPatientWithDOBMonthYear();
		Document retrievedPatientXml = retrievePatient(expectedPatient.getSsn());
		String retrievedDOB = XpathHelper.getString(retrievedPatientXml, "//m:patients/m:patient/dateOfBirth");
		assertEquals(expectedPatient.getDateOfBirth().toString(), retrievedDOB);
	}

	@Test
	public void validatePatientContainsDateOfBirthWithYearOnly() {
		Patient expectedPatient = IntegrationTestConfiguration.getPatientWithDOBYear();
		Document retrievedPatientXml = retrievePatient(expectedPatient.getSsn());
		String retrievedDOB = XpathHelper.getString(retrievedPatientXml, "//m:patients/m:patient/dateOfBirth");
		assertEquals(expectedPatient.getDateOfBirth().toString(), retrievedDOB);
	}
	
	private Document retrievePatient(String firstName, String lastName) {
		String searchUri = patientSearchURI + "?searchString=" + lastName + "," + firstName;
		Document result = client.getAsXml(searchUri);
		return result;
	}

	private Document retrievePatient(String ssn) {
		String searchUri = patientSearchURI + "?searchString=" + ssn;
		Document result = client.getAsXml(searchUri);
		return result;
	}
}
