package com.agilex.healthcare.mobilehealthplatform.restservice.mygoals;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;
import java.util.Calendar;
import java.util.Date;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriBuilder;

import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Mygoals;
import com.agilex.healthcare.mobilehealthplatform.domain.MygoalsList;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.enumeration.MygoalsInventoryType;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;


public class PatientMygoalsResourceTest {
	private static MobileHealthClientTestVersion client = null;
	private static PatientIdentifier aldieId = new PatientIdentifier("EDIPI", "PATID26");
	Patient aldiePatient = PatientLoader.loadPatient(aldieId, "zztest.patient26");
	DateTime today = new DateTime();
	Date twoWeeksAgo = today.minusDays(14).toDate();
	private Client cachedClient = null;

	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		AuthenticationInfo authenticationInfo = new AuthenticationInfo("zztest.patient26", "pass", "oauth");
		client = TestHelper.createMobileHealthClient(authenticationInfo);
	}
	
	protected Client getJerseyClient() {
		if (cachedClient == null) {
			cachedClient = client.getJerseyClient();
		}
		return cachedClient;
	}
	
	@AfterClass
	public static void destroyClient() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	

	@Test
	public void postFeelScaleMygoalsForTestPatient() {
		
		MygoalsList mygoals = createFeelScaleMygoals();
		assertTrue(mygoals.size() > 0);
		assertNotNull(mygoals);
	}	

	@Test
	public void postCurrentAndDesiredStateMygoalsForTestPatient() {
		MygoalsList mygoals = createCurrentAndDesireStateMygoals();
		assertTrue(mygoals.size() > 0);
		assertNotNull(mygoals);
	}

	@Test
	public void postReflectionsMygoalsForTestPatient() {
		MygoalsList mygoals = createReflectionMygoals();
		assertTrue(mygoals.size() > 0);
		assertNotNull(mygoals);
	}
	
	@Test
	public void postPrioritiesMygoalsForTestPatient() {
		MygoalsList mygoals = createPrioritiesMygoals();
		assertTrue(mygoals.size() > 0);
		assertNotNull(mygoals);		
	}
	
	@Test
	public void getLatestMygoalsByInventoryType() {
		MygoalsList retrievedLatestMygoals = retrieveLatestMygoals(MygoalsInventoryType.FEELINGS.name());
		assertNotNull(retrievedLatestMygoals);
		assertTrue(retrievedLatestMygoals.size() > 0);
		for (Mygoals mygoals : retrievedLatestMygoals) {
			assertEquals(MygoalsInventoryType.FEELINGS.name(), mygoals.getInventoryType());
		}
	}

	@Test
	public void getLatestMygoalsForTestPatient() {
		MygoalsList retrievedLatestMygoals = retrieveLatestMygoals();
		MygoalsList retrievedMygoals = retrieveMygoals();
		assertNotNull(retrievedLatestMygoals);
		assertTrue(retrievedLatestMygoals.size() > 0);
		assertTrue(retrievedMygoals.size() >= retrievedLatestMygoals.size());

	}
	
	@Test
	public void getMygoalsbyResponseId() {

		Mygoals mygoal = createAndPopulateSampleMygoals(aldieId);
		mygoal.setQuestionKey("feelings-physically");
		Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
	
		mygoal = new Mygoals();
		mygoal.setPatientIdentifier(savedMygoals.getPatientIdentifier());
		mygoal.setId(savedMygoals.getId());
		Mygoals retrievedMygoals = retrieveMygoalsById(mygoal);
		
		assertNotNull(retrievedMygoals);
		assertEquals(aldieId.getUniqueId(), retrievedMygoals.getPatientIdentifier().getUniqueId());
		assertNotNull(retrievedMygoals.getId());
		assertEquals(retrievedMygoals.getId(), savedMygoals.getId());
	}

	@Test
	public void getMygoalsReportForTestPatient() {
		String result = retrieveMygoalsReport();
		assertNotNull(result);
		assertTrue(result.startsWith("%PDF"));
	}

	@Test
	public void getMygoalsForTestPatient() throws InterruptedException {
		Thread.sleep(600);
		createMygoals();
		MygoalsList retrievedMygoals = retrieveMygoals();
		assertNotNull(retrievedMygoals);
		assertTrue(retrievedMygoals.size() > 0);
	}
	
	private MygoalsList createFeelScaleMygoals() {
		MygoalsList resultMygoalsList = new MygoalsList();
		MygoalsList mygoalsList = populateFeelings(aldieId, today.toDate());
		for (Mygoals mygoal : mygoalsList) {
			Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
			assertNotNull(savedMygoals);
			resultMygoalsList.add(savedMygoals);
		}
		return resultMygoalsList;
	}
	
	private MygoalsList createCurrentAndDesireStateMygoals() {
		MygoalsList resultMygoalsList = new MygoalsList();
		MygoalsList mygoalsList = populateCurrentAndDesiredStates(aldieId, today.toDate());
		for (Mygoals mygoal : mygoalsList) {
			mygoal.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
			Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
			assertNotNull(savedMygoals);
			resultMygoalsList.add(savedMygoals);
		}
		return resultMygoalsList;
	}

	private MygoalsList createReflectionMygoals() {
		MygoalsList resultMygoalsList = new MygoalsList();
		MygoalsList mygoalsList = populateReflections(aldieId, today.toDate());
		for (Mygoals mygoal : mygoalsList) {
			mygoal.setInventoryType(MygoalsInventoryType.REFLECTIONS.name());
			Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
			assertNotNull(savedMygoals);
			resultMygoalsList.add(savedMygoals);
		}
		return resultMygoalsList;
	}
	
	private MygoalsList createPrioritiesMygoals() {
		MygoalsList resultMygoalsList = new MygoalsList();
		MygoalsList mygoalsList = populatePriorities(aldieId, today.toDate());
		for (Mygoals mygoal : mygoalsList) {
			mygoal.setInventoryType(MygoalsInventoryType.PRIORITIES.name());
			Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
			assertNotNull(savedMygoals);
			resultMygoalsList.add(savedMygoals);
		}
		return resultMygoalsList;
	}
	
	private void createMygoals() {
		MygoalsList mygoalsList = populateFeelings(aldieId, today.toDate());
		for (Mygoals mygoal : mygoalsList) {
			mygoal.setInventoryType(MygoalsInventoryType.FEELINGS.name());
			Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
			assertNotNull(savedMygoals);
		}
		
		mygoalsList = populateCurrentAndDesiredStates(aldieId, today.toDate());
		for (Mygoals mygoal : mygoalsList) {
			mygoal.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
			Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
			assertNotNull(savedMygoals);
		}

		mygoalsList = populateReflections(aldieId, today.toDate());
		for (Mygoals mygoal : mygoalsList) {
			mygoal.setInventoryType(MygoalsInventoryType.REFLECTIONS.name());
			Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
			assertNotNull(savedMygoals);
		}

		mygoalsList = populatePriorities(aldieId, today.toDate());
		for (Mygoals mygoal : mygoalsList) {
			mygoal.setInventoryType(MygoalsInventoryType.PRIORITIES.name());
			Mygoals savedMygoals = postAndRetrieveMygoals(mygoal);
			assertNotNull(savedMygoals);
		}
		
	}	
	private Mygoals retrieveMygoalsById(Mygoals mygoals) {
		URI baseMygoalsUri = getBaseMygoalsURI(aldiePatient);
		URI mygoalsUri = UriBuilder.fromUri(baseMygoalsUri).path("id").path(mygoals.getId()).build();
		Mygoals resultMygoals = getJerseyClient().resource(mygoalsUri).type(MediaType.APPLICATION_JSON).get(Mygoals.class);
		return resultMygoals;
	}
	
	private MygoalsList retrieveLatestMygoals(String invType) {
		URI baseMygoalsUri = getBaseMygoalsURI(aldiePatient);
		URI latestmygoalsUri = UriBuilder.fromUri(baseMygoalsUri).path("latest").path(invType).build();
		MygoalsList resultMygoals = getJerseyClient().resource(latestmygoalsUri).type(MediaType.APPLICATION_JSON).get(MygoalsList.class);
		return resultMygoals;
	}

	private MygoalsList retrieveLatestMygoals() {
		URI baseMygoalsUri = getBaseMygoalsURI(aldiePatient);
		URI latestmygoalsUri = UriBuilder.fromUri(baseMygoalsUri).path("latest").build();
		MygoalsList resultMygoals = getJerseyClient().resource(latestmygoalsUri).type(MediaType.APPLICATION_JSON).get(MygoalsList.class);
		return resultMygoals;
	}

	private String retrieveMygoalsReport() {
		URI baseMygoalsUri = getBaseMygoalsURI(aldiePatient);
		URI mygoalsReportUri = UriBuilder.fromUri(baseMygoalsUri).path("report").build();
		boolean test = false;
		String result = null;
		try {
			result = getJerseyClient().resource(mygoalsReportUri).accept("application/pdf").get(String.class);
		} catch (UniformInterfaceException e) {
			if (Status.PRECONDITION_FAILED.getStatusCode() == e.getResponse().getStatus()) {
		test = true;
			}
		}
		
		return result;
	}
	
	private MygoalsList retrieveMygoals() {
		URI baseMygoalsUri =  getBaseMygoalsURI(aldiePatient);
		URI allMygoalsUri = UriBuilder.fromUri(baseMygoalsUri).path("all").build();
		MygoalsList resultMygoals = getJerseyClient().resource(allMygoalsUri).type(MediaType.APPLICATION_JSON).get(MygoalsList.class);
		return resultMygoals;
	}
	
	private Mygoals postAndRetrieveMygoals(Mygoals questionResponse) {
		URI patientMygoalsUri =  getMygoalsURI(aldiePatient);
		URI latestMygoalsUri = UriBuilder.fromUri(patientMygoalsUri).path("latest").build();
		Mygoals resultMygoals = getJerseyClient().resource(latestMygoalsUri).accept(MediaType.APPLICATION_JSON).post(Mygoals.class, questionResponse);
		return resultMygoals;
	
	}

	private URI getMygoalsURI(Patient patient) {
		URI baseMygoalsUri = getBaseMygoalsURI(patient);
		return baseMygoalsUri;

	}
	
	private URI getBaseMygoalsURI(Patient patient) {
		URI patientMygoalsUri = patient.getLink().getUriByTitle(LinkTitles.MyGoalsInventory);
		URI mygoalsUri = UriBuilder.fromUri(patientMygoalsUri).build();
		return mygoalsUri;

	}	
	
	private Mygoals createAndPopulateSampleMygoals(PatientIdentifier patientIdentifier) {
		Mygoals mygoals = new Mygoals();
		DateTime today = new DateTime();
		Date twoWeeksAgo = today.minusDays(14).toDate();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(twoWeeksAgo);	
		calendar.add(Calendar.SECOND, 600);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setDateUpdated(twoWeeksAgo);
		mygoals.setInventoryType(MygoalsInventoryType.FEELINGS.name());
		mygoals.setElapsedTime(10);
		mygoals.setAnswer("4");

		return mygoals;
	}
	
	private MygoalsList populateFeelings(PatientIdentifier patientIdentifier, Date dateUpdated) {
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(dateUpdated);
	
		MygoalsList mygoalsList = new MygoalsList();
		Mygoals mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.FEELINGS.name());
		mygoals.setQuestionKey("feelings-physically");
		mygoals.setAnswer("4");
		calendar.add(Calendar.SECOND, 300);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);

		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.FEELINGS.name());
		mygoals.setQuestionKey("feelings-mentally");
		mygoals.setAnswer("6");
		calendar.add(Calendar.SECOND, 310);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.FEELINGS.name());
		mygoals.setQuestionKey("feelings-day-to-day");
		mygoals.setAnswer("7");
		calendar.add(Calendar.SECOND, 320);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);	
		return mygoalsList;
	}
	
	private MygoalsList populateCurrentAndDesiredStates(PatientIdentifier patientIdentifier, Date dateUpdated) {
		MygoalsList mygoalsList = new MygoalsList();
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(dateUpdated);
		
		Mygoals mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-body-slider");
		mygoals.setAnswer("4");
		calendar.add(Calendar.SECOND, 330);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);

		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-body-slider");
		mygoals.setAnswer("4");
		calendar.add(Calendar.SECOND, 330);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-recharge-slider");
		mygoals.setAnswer("6");
		calendar.add(Calendar.SECOND, 340);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-recharge-slider");
		mygoals.setAnswer("4");
		calendar.add(Calendar.SECOND, 340);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);		
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-fuel-slider");
		mygoals.setAnswer("7");
		calendar.add(Calendar.SECOND, 350);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);	
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-fuel-slider");
		mygoals.setAnswer("7");
		calendar.add(Calendar.SECOND, 350);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);	
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-life-slider");
		mygoals.setAnswer("8");
		calendar.add(Calendar.SECOND, 360);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);

		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-life-slider");
		mygoals.setAnswer("8");
		calendar.add(Calendar.SECOND, 360);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-family-slider");
		mygoals.setAnswer("6");
		calendar.add(Calendar.SECOND, 370);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-family-slider");
		mygoals.setAnswer("6");
		calendar.add(Calendar.SECOND, 370);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-soul-slider");
		mygoals.setAnswer("5");
		calendar.add(Calendar.SECOND, 380);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-soul-slider");
		mygoals.setAnswer("5");
		calendar.add(Calendar.SECOND, 380);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-surroundings-slider");
		mygoals.setAnswer("3");
		calendar.add(Calendar.SECOND, 390);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);

		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-surroundings-slider");
		mygoals.setAnswer("3");
		calendar.add(Calendar.SECOND, 390);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-mind-slider");
		mygoals.setAnswer("2");
		calendar.add(Calendar.SECOND, 400);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-mind-slider");
		mygoals.setAnswer("3");
		calendar.add(Calendar.SECOND, 400);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-prevention-slider");
		mygoals.setAnswer("3");
		calendar.add(Calendar.SECOND, 410);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-prevention-slider");
		mygoals.setAnswer("3");
		calendar.add(Calendar.SECOND, 410);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Current-intervention-slider");
		mygoals.setAnswer("2");
		calendar.add(Calendar.SECOND, 420);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);		
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.CURRENT_AND_DESIRED_STATE.name());
		mygoals.setQuestionKey("Desired-intervention-slider");
		mygoals.setAnswer("2");
		calendar.add(Calendar.SECOND, 420);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		return mygoalsList;
	}

	private MygoalsList populateReflections(PatientIdentifier patientIdentifier, Date dateUpdated) {
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(dateUpdated);
		
		MygoalsList mygoalsList = new MygoalsList();
		Mygoals mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.REFLECTIONS.name());
		mygoals.setQuestionKey("reflection-matters");
		mygoals.setAnswer("This is reflection matters");
		calendar.add(Calendar.SECOND, 430);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);

		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.REFLECTIONS.name());
		mygoals.setQuestionKey("reflection-joy");
		mygoals.setAnswer("This is reflection joy");
		calendar.add(Calendar.SECOND, 440);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.REFLECTIONS.name());
		mygoals.setQuestionKey("reflection-sorrow");
		mygoals.setAnswer("This is reflection sorrow");
		calendar.add(Calendar.SECOND, 450);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);	

		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.REFLECTIONS.name());
		mygoals.setQuestionKey("reflection-vision");
		mygoals.setAnswer("This is reflection vision");
		calendar.add(Calendar.SECOND, 460);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);		
		return mygoalsList;
	}	
	
	private MygoalsList populatePriorities(PatientIdentifier patientIdentifier, Date dateUpdated) {
		
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(dateUpdated);
		
		MygoalsList mygoalsList = new MygoalsList();
		Mygoals mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.PRIORITIES.name());
		mygoals.setQuestionKey("priority1-area");
		mygoals.setAnswer("Working My Body");
		calendar.add(Calendar.SECOND, 470);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);

		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.PRIORITIES.name());
		mygoals.setQuestionKey("priority1-goal");
		mygoals.setAnswer("Ride my bike 30 minutes daily");
		calendar.add(Calendar.SECOND, 480);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);
		
		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.PRIORITIES.name());
		mygoals.setQuestionKey("priority2-area");
		mygoals.setAnswer("My Personal Development");
		calendar.add(Calendar.SECOND, 490);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);	

		mygoals = new Mygoals();
		mygoals.setPatientId(patientIdentifier.getUniqueId());
		mygoals.setPatientIdentifier(patientIdentifier);
		mygoals.setInventoryType(MygoalsInventoryType.PRIORITIES.name());
		mygoals.setQuestionKey("priority2-goal");
		mygoals.setAnswer("I want to discuss with my healthcare team.");
		calendar.add(Calendar.SECOND, 500);
		mygoals.setDateUpdated(calendar.getTime());
		mygoals.setElapsedTime(10);
		mygoalsList.add(mygoals);	
		
		return mygoalsList;
	}
	
	
}