package com.agilex.healthcare.mobilehealthplatform.restservice.medications;

import static org.junit.Assert.assertEquals;

import java.net.URI;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;

public class PatientMedicationsWithNoDataTest {

	private URI medLink;
	private MobileHealthClientTestVersion client;

    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Before
	public void setup() {

		String userName = "zztest.patient76";
		AuthenticationInfo authenticationInfo = new AuthenticationInfo(userName, "pass", "oauth");
		client = TestHelper.createMobileHealthClient(authenticationInfo);
		
		PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "NO-DATA-MOCK");
		Patient testPatient = PatientLoader.loadPatient(patientIdentifier, userName);
		
		medLink = testPatient.getInpatientMedicationsUri();
	}
	
	@After
	public void teardown() {
		client.getJerseyClient().destroy();
	}

	@Test
	public void patientWithNoDataReturnsNoDataFoundMed() {
		Document medications = client.getAsXml(medLink);
		String size = XpathHelper.getString(medications, "/m:medications/@size");
		assertEquals("0", size);
	}
}
