package com.agilex.healthcare.mobilehealthplatform.restservice.medications;

import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.restservice.GeneralResourceTestBase;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.utility.ModeHelper;

public class PatientMedicationsResourceTest extends GeneralResourceTestBase {
	String uri = null;

    @BeforeClass
    public static void checkModeOfOperation(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Before
	public void setup() {
		Patient patient = PatientLoader.loadTestLabPatient();
		this.uri = patient.getMedicationsUri().toString();
	}

	@Override
	protected String getResourcePath() {
		return this.uri;
	}

	@Test
	public void sample() {
		// this is required because of issues with inherited test classes
	}

}
