package com.agilex.healthcare.mobilehealthplatform.restservice.medications;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.net.URI;
import java.util.Date;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

import junit.framework.Assert;

import org.junit.*;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.domain.code.MedicationRefillCode;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.UniformInterfaceException;

@Ignore
public class MedicationRefillResourceTest {

	private String patientId = "D123401";
	private static MobileHealthClientTestVersion client;

	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		client = TestHelper.createMobileHealthClient();
	}
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}

	@Test
	public void verifyRetrieve() {
		URI uri = createMedicationRefillsUri(patientId);
		Medications medications = client.getJerseyClient().resource(uri).get(Medications.class);
		
		Assert.assertNotNull(medications);
		Assert.assertTrue(medications.size() > 0);
	}
	
	@Test
	public void verifyPutWhenRefillEligible() {
		URI uri = createMedicationRefillsUri(patientId);
		Medications retrievedMedications = client.getJerseyClient().resource(uri).get(Medications.class);

		Medication medicationToPut = null;
		for (Medication medication : retrievedMedications) {
			if (MedicationRefillCode.REFILL_ACTION_ELIGIBLE.equals(medication.getRefillAction())) {
				medicationToPut = medication;
				break;
			}
		}
		Medication updatedMedication = null;
		if (medicationToPut != null) {
			updatedMedication = client.getJerseyClient().resource(medicationToPut.getLink().getUriByTitle(LinkTitles.RelatedMedicationRefills)).type(MediaType.APPLICATION_XML).accept("application/xml").put(Medication.class, medicationToPut);
		} else {
			fail();
		}

		assertFalse(updatedMedication.isEligibleForRefill());
		assertEquals(MedicationRefillCode.REFILL_ACTION_NONE, updatedMedication.getRefillAction());
	}

	@Test(expected = UniformInterfaceException.class)
	public void verifyPutWhenRefillNotEligible() {
		URI uri = createMedicationRefillsUri(patientId);
		Medications retrievedMedications = client.getJerseyClient().resource(uri).get(Medications.class);

		Medication medicationToPut = null;
		for (Medication medication : retrievedMedications) {
			if (MedicationRefillCode.REFILL_ACTION_NONE.equals(medication.getRefillAction())) {
				medicationToPut = medication;
				break;
			}
		}

		if (medicationToPut != null) {
			URI refillUri = createMedicationRefillsUriToBeRefilled(patientId);
			client.getJerseyClient().resource(refillUri).type(MediaType.APPLICATION_XML).accept("application/xml").put(Medication.class, medicationToPut);
			// Exception should be thrown here. We are simulating a response that is not okay - for our mock, we simply try to refill a non-refillable medication. 
			// In the real system, this could come back at any time if the request to refill fails.
		} else {
			fail();
		}
	}

	public URI createMedicationRefillsUri(String patientId) {
		String medicationsUriAsString = String.format("%s/patient/EDIPI/%s/medication-refills", IntegrationTestConfiguration.getMobileHealthServerBaseUri(), patientId);
		URI medicationUri = UriBuilder.fromUri(medicationsUriAsString).build();
		return medicationUri;
	}

	public URI createMedicationRefillsUriToBeRefilled(String patientId) {
		String medicationsUriAsString = String.format("%s/patient/EDIPI/%s/medication-refills/refill", IntegrationTestConfiguration.getMobileHealthServerBaseUri(), patientId);
		URI medicationUri = UriBuilder.fromUri(medicationsUriAsString).build();
		return medicationUri;
	}
}
