package com.agilex.healthcare.mobilehealthplatform.restservice.medications;

import static org.junit.Assert.assertNotNull;

import java.net.URI;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.XpathHelper;

public class MedicationDetailTest {
	private Medication expectedMedication = IntegrationTestConfiguration.getOutpatientMedication();
	private static MobileHealthClientTestVersion client;
	private String baseUri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();

	@BeforeClass
	public static void startup() {
		client = TestHelper.createMobileHealthClient();
	}
	
	@AfterClass
	public static void destroy() {
		client.getJerseyClient().destroy();
		client = null;
	}
	
	@Test
	public void nada() {
	}

	@Ignore
	public void verifyMedicationDetailsAreReturnedForValidPatientAndOrder() {
		Node medNode = retrieveMedicationNode();
		assertNotNull(medNode);

	}

	@Ignore
	public void varifyMedicationDetailIsNullForInvalidInput() {
		String medicationDetailUri = getMedicationDetailUri("XYZ", "40");
		client.getAsXml(medicationDetailUri);
	}

	private URI getMedicationsUri() {
		Patient testPatient = PatientLoader.loadTestMedPatient();
		URI medLink = testPatient.getActiveMedicationsUri();
		return medLink;
	}

	private Node retrieveMedicationNode() {
		Document meds = client.getAsXml(getMedicationsUri());
		String orderNumber = expectedMedication.getOrderNumber();
		Node medicationDetailAtomLinkNode = XpathHelper
				.getNode(meds, "//m:medications/m:medication[@orderNumber='" + orderNumber + "']/atom:link[@title='" + LinkTitles.PatientMedicationDetail + "']");
		Node namedItem = medicationDetailAtomLinkNode.getAttributes().getNamedItem("href");
		String medicationDetailUri = namedItem.getNodeValue();

		Document retrievedMedication = client.getAsXml(medicationDetailUri);
		Node medicationNode = XpathHelper.getNode(retrievedMedication, "//m:medication");

		return medicationNode;
	}

	private String getMedicationDetailUri(String patientId, String orderNumber) {
		return baseUri + "/patient/" + patientId + "/medication/" + orderNumber + "/detail";

	}

}
