package com.agilex.healthcare.mobilehealthplatform.restservice.login;

import static org.junit.Assert.assertNotNull;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.NullCheckerAssert;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;

public class LoginResourceTest {
	Client client;
	
	@Before
	public void setup() {
		client = TestHelper.createJerseyClient();
	}
	
	@After
	public void tearDown() {
		client.destroy();
		client = null;
	}
	
	@Test
	public void loginResourceContainsMhpUser() {
		Document userSessionResource = client.resource(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("login").get(Document.class);
		Node mhpUser = XpathHelper.getNode(userSessionResource, "//m:userSession/m:mhpuser");
		assertNotNull(mhpUser);
	}

	@Test
	public void loginResourceContainsUserId() {
		Document userSessionResource = client.resource(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("login").get(Document.class);
		String value = XpathHelper.getString(userSessionResource, "//m:userSession/m:mhpuser/id");
		NullCheckerAssert.assertNotNullish(value);

	}

	@Test
	public void loginResourceContainsUserLastName() {
		Document userSessionResource = client.resource(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("login").get(Document.class);
		String value = XpathHelper.getString(userSessionResource, "//m:userSession/m:mhpuser/lastName");
		NullCheckerAssert.assertNotNullish(value);
	}

	@Test
	public void loginResourceContainsClientTimeoutSetting() {
		Document userSessionResource = client.resource(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("login").get(Document.class);
		String value = XpathHelper.getString(userSessionResource, "//m:userSession/@clientTimeout");
		NullCheckerAssert.assertNotNullish(value);
	}
	
}
