package com.agilex.healthcare.mobilehealthplatform.restservice.ical;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.WebResource;

public class PublicCalendarResourceTest {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(PublicCalendarResourceTest.class);

	private static MobileHealthClientTestVersion client;

	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		client = TestHelper.createMobileHealthClient();
	}
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void fetchCalendarEventsTest() {
		URI testUri = createPublicCalendarEventsUri("EDIPI", "D123401");

		Appointments appointments = getAppointments(testUri);
		assertTrue(appointments.size() >= 0);
	}

	@Test
	public void fetchCalendarFeedTest() {
		URI testUri = createPublicCalendarFeedUri("EDIPI", "D123401");

		String ical = client.getJerseyClient().resource(testUri).get(String.class);
		assertNotNull(ical);
	}

	private URI createPublicCalendarEventsUri(String assigningAuthority, String patientId) {
		String baseUri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();
		String patientEventsUri = String.format("%s/public/calendar/patient/%s/%s/events", baseUri, assigningAuthority, patientId);
		return UriBuilder.fromPath(patientEventsUri).build();
	}

	private URI createPublicCalendarFeedUri(String assigningAuthority, String patientId) {
		String baseUri = IntegrationTestConfiguration.getMobileHealthServerBaseUri();
		String patientEventsUri = String.format("%s/public/calendar/patient/%s/%s/feed", baseUri, assigningAuthority, patientId);
		return UriBuilder.fromPath(patientEventsUri).build();
	}

	private Appointments getAppointments(URI appointmentsUri) {
		WebResource webResource = client.getJerseyClient().resource(appointmentsUri);
		return webResource.get(Appointments.class);
	}
}
