package com.agilex.healthcare.mobilehealthplatform.restservice.customview;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;
import java.util.Date;

import javax.ws.rs.core.MediaType;

import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.CustomViewList;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;


public class CustomViewResourceTest {
	private static PatientIdentifier aldieId = new PatientIdentifier("EDIPI", "PATID26");
	Patient aldiePatient = PatientLoader.loadPatientAsProvider(aldieId, "zztest.staff01");
	DateTime today = new DateTime();
	Date twoWeeksAgo = today.minusDays(14).toDate();
	
	private boolean defaultDebug = true;
	private WebResource cachedResource = null;
	
	private Client jerseyClient;

	protected WebResource getResourceHandle(URI customViewUri) {
		if (cachedResource == null) {
			if (defaultDebug)
				System.out.println("initializing resource with URI " + customViewUri);
			cachedResource = jerseyClient.resource(customViewUri);
		}
		return cachedResource;
	}


	@BeforeClass
	public static void checkWhetherTestsAreRunningInVaProviderMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
	}
	
	@AfterClass
	public static void destroyClient() {
		
	}

	@Test
	public void fetchCustomViewList() {
		CustomViewList result = retrieveCustomViewList();
		assertNotNull(result);
		assertTrue(result.size() > 0);
	}

	private CustomViewList retrieveCustomViewList() {
		URI customViewUri = getCustomViewURI(aldiePatient);
				
		jerseyClient = TestHelper.createMobileHealthClient().getJerseyClient();
		CustomViewList result = getResourceHandle(customViewUri).type(MediaType.APPLICATION_JSON).get(CustomViewList.class);
		
		jerseyClient.destroy();
		jerseyClient = null;
		
		return result;
	}
	
	private URI getCustomViewURI(Patient patient) {
		URI customViewUri = patient.getLink().getUriByTitle(LinkTitles.CustomDataView);
		return customViewUri;

	}	
	
	protected String getPatientResourcePath() {
		return IntegrationTestConfiguration.getMobileHealthServerBaseUri() + "/patients";
	}	
	
}