package com.agilex.healthcare.mobilehealthplatform.restservice.calendar;

import static org.junit.Assert.assertEquals;

import java.net.URI;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvent;
import com.agilex.healthcare.mobilehealthplatform.domain.CalendarEvents;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ModeHelper;

@Ignore
public class CalendarResourceTest {

	private static MobileHealthClientTestVersion client;

	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		client = TestHelper.createMobileHealthClient();
	}
	
	@AfterClass
	public static void tearDown() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}

	private PatientIdentifier getPatient() {
		return new PatientIdentifier("EDIPI", "INT-TEST-MOCK");
	}

	@Test
	public void testGetCalendarEvents() {
		PatientIdentifier patientIdentifier = getPatient();
		createAndSaveCalendarEvents(patientIdentifier);

		URI calendarUri = getCalendarEventUri(patientIdentifier);
		CalendarEvents retrievedEvents = client.getJerseyClient().resource(calendarUri).get(CalendarEvents.class);
		assertEquals(3, retrievedEvents.size());
	}

	private CalendarEvent createBasicCalendarEvent(PatientIdentifier patientIdentifier) {
		CalendarEvent calendarEvent = new CalendarEvent();
		calendarEvent.setTitle("Test Calendar Title");
		calendarEvent.setNotes("Test Calendar Notes");
		calendarEvent.setStartDate(DateHelper.getTomorrow());
		calendarEvent.setAlertDuration(5);
		calendarEvent.setPatientIdentifier(patientIdentifier);

		return calendarEvent;
	}

	private CalendarEvent createAndSaveCalendarEvent(PatientIdentifier patientIdentifier) {
		CalendarEvent calendarEvent = createBasicCalendarEvent(patientIdentifier);
		URI uri = getCalendarEventUri(patientIdentifier);
		return client.getJerseyClient().resource(uri).post(CalendarEvent.class, calendarEvent);
	}

	private CalendarEvents createAndSaveCalendarEvents(PatientIdentifier patientIdentifier) {
		CalendarEvents events = new CalendarEvents();
		events.add(createAndSaveCalendarEvent(patientIdentifier));
		events.add(createAndSaveCalendarEvent(patientIdentifier));
		events.add(createAndSaveCalendarEvent(patientIdentifier));

		return events;
	}

	private URI getCalendarEventUri(PatientIdentifier patientIdentifier) {
		String calendarUri = String.format("%s/patient/%s/%s/calendar/calendarEvent", IntegrationTestConfiguration.getMobileHealthServerBaseUri(), patientIdentifier.getAssigningAuthority(), patientIdentifier.getUniqueId());
		URI calendarEventUri = UriBuilder.fromUri(calendarUri).build();
		return calendarEventUri;
	}

}
