package com.agilex.healthcare.mobilehealthplatform.restservice.assessmentresults;

import static org.junit.Assert.assertEquals;

import java.net.URI;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.client.AuthenticationInfo;
import com.agilex.healthcare.mobilehealthplatform.domain.Assessment;
import com.agilex.healthcare.mobilehealthplatform.domain.Assessments;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.sun.jersey.api.client.Client;

public class PatientAssessmentsResourceQuestionsTest {
	private static Client client;
	private PatientIdentifier aldieId = new PatientIdentifier("EDIPI", "PATID26");
	private Patient aldiePatient = PatientLoader.loadPatient(aldieId, "zztest.patient26");
	private String assessmentId = "ptsd";

	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		AuthenticationInfo authenticationInfo = new AuthenticationInfo("zztest.patient26", "pass", "oauth");
		client = TestHelper.createMobileHealthClient(authenticationInfo).getJerseyClient();
	}
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.destroy();
			client = null;
		}
	}

	@Test
	public void getQuestionsForPtsdByRetrievingSingleAssessment() {
		Assessment assessment = getAssessment(aldiePatient, assessmentId);
		assessment = client.resource(assessment.getSelfUri()).get(Assessment.class);
		assertEquals(17, assessment.getQuestions().size());
	}

	private Assessment getAssessment(Patient patient, String assessmentId) {
		URI patientAssessmentsUri = patient.getLink().getUriByTitle(LinkTitles.Assessments);
		Assessments assessments = client.resource(patientAssessmentsUri).get(Assessments.class);
		Assessment assessment = assessments.getAssessmentById(assessmentId);

		if (assessment == null)
			throw new RuntimeException("Unable to find assessment " + assessmentId);

		return assessment;
	}

}