package com.agilex.healthcare.mobilehealthplatform.restservice.appointments;

import static org.junit.Assert.assertNotNull;

import java.net.URI;

import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Appointments;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class MentalHealthAppointmentResourceTest {
	private MobileHealthClientTestVersion client;
	private PatientIdentifier patientIdentifier = new PatientIdentifier("EDIPI", "D123401");
	
    @BeforeClass
    public static void isVeteranMode(){
        Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
    }
    
	@Before
	public void setup() {
		client = TestHelper.createMobileHealthClient("zztest.patient01", "pass", "oauth");
	}
	
	@After
	public void tearDown() {
		client.getJerseyClient().destroy();
		client = null;
	}
	
	@Test
	public void validateRetrieval() {
		Patient patient = PatientLoader.loadPatient(patientIdentifier, "zztest.patient01", "pass", "oauth");
		URI mhAppointmentUri = patient.getMentalHealthAppointmentUri();
		
		Appointments appointments = client.getJerseyClient().resource(mhAppointmentUri).get(Appointments.class);
		assertNotNull(appointments);
	}
}
