package com.agilex.healthcare.mobilehealthplatform.restservice.appointments;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.net.URI;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentMetric;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.ModeHelper;

public class AppointmentMetricsResourceTest {

	private static final org.apache.commons.logging.Log LOGGER = org.apache.commons.logging.LogFactory.getLog(AppointmentMetricsResourceTest.class);

	private static MobileHealthClientTestVersion client;
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInProperModes() {
		Assume.assumeTrue(ModeHelper.isMode("dev"));
		client = TestHelper.createMobileHealthClient();
	}
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}
	
	@Test
	public void verifyNoIcnOrDfnMetric() {
		URI uri = createAppointmentNoIcnOrDfnMetricUri();
		testMetric(uri);
	}
	
	@Test
	public void verifyNoDfnCancelRequestMetric() {
		URI uri = createAppointmentNoDfnCancelRequestMetricUri();
		testMetric(uri);
	}

	private void testMetric(URI uri) {
		AppointmentMetric metric = client.getJerseyClient().resource(uri).post(AppointmentMetric.class);
		int value1 = metric.getValue();
		assertTrue(value1 > 0);
		
		metric = client.getJerseyClient().resource(uri).post(AppointmentMetric.class);
		int value2 = metric.getValue();
		
		assertEquals(value1 + 1, value2);
	}
	
	private URI createAppointmentNoIcnOrDfnMetricUri() {
		URI uri = IntegrationTestConfiguration.getResourceUri(LinkTitles.AppointmentMetricsNoIcnOrDfn);
		return uri;
	}
	
	private URI createAppointmentNoDfnCancelRequestMetricUri() {
		return IntegrationTestConfiguration.getResourceUri(LinkTitles.AppointmentMetricsNoDfnCancelRequest);
	}
}
