package com.agilex.healthcare.mobilehealthplatform.restservice.admission;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.net.URI;
import java.util.Date;

import javax.ws.rs.core.UriBuilder;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.clientapi.MobileHealthClientTestVersion;
import com.agilex.healthcare.mobilehealthplatform.domain.Admission;
import com.agilex.healthcare.mobilehealthplatform.domain.Admissions;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.testutility.PatientLoader;
import com.agilex.healthcare.testutility.TestHelper;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;

public class AdmissionResourceTest {
	private static MobileHealthClientTestVersion client;
	Patient testPatient = PatientLoader.loadTestPatient();
	private Document admissionsForTestPatient;

	@BeforeClass
	public static void checkWhetherTestsAreRunningInCinMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev"));
		client = TestHelper.createMobileHealthClient();
	}
	
	@AfterClass
	public static void destroy() {
		if (client != null) {
			client.getJerseyClient().destroy();
			client = null;
		}
	}

	@Before
	public void initialize() {
		admissionsForTestPatient = client.getAsXml(getAdmissionsUri());
	}

	@Test
	public void validateRetrieveAdmissions() {
		assertNotNull(admissionsForTestPatient);
		NodeList admissionList = XpathHelper.getNodeList(admissionsForTestPatient, "//m:admission");
		assertTrue(admissionList.getLength() >= 10);
	}

	@Test
//	@Ignore
	public void validateSortedInDescOrder() {
		NodeList admissionList = XpathHelper.getNodeList(admissionsForTestPatient, "//m:admission");
		Date previousDate = null;
		for (int i = 0; i < admissionList.getLength(); i++) {
			Node admissionNode = admissionList.item(i);
			String admissionDateAsString = XpathHelper.getString(admissionNode, "@admissionDate");
			Date admissionDate = DateHelper.parseDateTime(admissionDateAsString);
			if (previousDate != null) {
				assertTrue(admissionDate.compareTo(previousDate) <= 0);
			}
			previousDate = admissionDate;
		}
	}

	private URI getAdmissionsUri() {
		return testPatient.getLink().getUriByTitle(LinkTitles.PatientAdmissions);
	}

	@Test
	public void retrieveAdmissionsByEntryDate() {
		URI uri = UriBuilder.fromUri(getAdmissionsUri()).queryParam("entrydate", "1/1/2000").build();
		Admissions admissions = client.getJerseyClient().resource(uri).get(Admissions.class);
		for (Admission admission : admissions) {
			assertTrue(admission.getAdmissionDate().compareTo(DateHelper.parseDate("1/1/2000")) >= 0);
			assertTrue(admission.getAdmissionDate().compareTo(DateHelper.parseDate("1/2/2000")) <= 0);
		}
	}
}
