package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.net.URI;
import java.net.URISyntaxException;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriBuilder;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.domain.AppointmentProcessedAsPerUserNeed;
import com.agilex.healthcare.mobilehealthplatform.domain.UserFeedback;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;

public class UserFeedbackTest {
	Client jerseyClient;
	
	private URI getFeedbackUri() {
		return UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("public").path("feedback").build();
	}

	private URI getAppointmentRequestFeedbackUri() {
		return UriBuilder.fromPath(IntegrationTestConfiguration.getMobileHealthServerBaseUri()).path("public").path("feedback").path("appointment-request").build();
	}
	
	@Before
	public void setup() {
		jerseyClient = new Client();
	}
	
	@After
	public void tearDown() {
		jerseyClient.destroy();
		jerseyClient = null;
	}
	
	@Test
	public void isUserFeedbacksubmitted() throws URISyntaxException {

		UserFeedback userFeedback = new UserFeedback();
		userFeedback.setType("patientViewer");
		userFeedback.setComments("This application is very good");
		
		WebResource resourceHandle = jerseyClient.resource(getFeedbackUri());
		ClientResponse response = resourceHandle.type(MediaType.APPLICATION_XML).accept("application/xml").post(ClientResponse.class, userFeedback);
		assertEquals(Status.OK.getStatusCode(), response.getStatus());
	}

	@Test
	public void validateAppointmentRequestFeedbackSubmission() throws URISyntaxException {
		UserFeedback userFeedback = new UserFeedback();
		userFeedback.setComments("Appointment Request was processed very quickly");
		userFeedback.setRecommendationRating(new Integer(5));
		userFeedback.setAppointmentProcessedAsPerUserNeed(AppointmentProcessedAsPerUserNeed.Always);
		WebResource resourceHandle = jerseyClient.resource(getAppointmentRequestFeedbackUri());
		UserFeedback feedback = resourceHandle.type(MediaType.APPLICATION_XML).accept("application/xml").post(UserFeedback.class, userFeedback);
		assertNotNull(feedback.getUniqueId());
	}
	
}
