package com.agilex.healthcare.mobilehealthplatform.restservice;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.net.URI;

import javax.ws.rs.core.MediaType;

import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.AtomLinks;
import com.agilex.healthcare.mobilehealthplatform.domain.LinkTitles;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.atom.AtomUtility;
import com.sun.jersey.api.client.Client;
import com.sun.syndication.feed.synd.SyndFeed;

public class ResourceDirectoryResourceTest {
	
	private ResourceDirectory resourceDirectory = null;
	private static Client jerseyClient;
	
	@BeforeClass
	public static void checkWhetherTestsAreRunningInCIHMode() {
		Assume.assumeTrue(ModeHelper.isMode("va-veteran-dev", "dev"));
		jerseyClient = new Client();
	}
	
	@AfterClass
	public static void destroy() {
		if (jerseyClient != null) {
			jerseyClient.destroy();
			jerseyClient = null;
		}
	}

	@Before
	public void getResourceAsXml() {
		resourceDirectory = jerseyClient.resource(getResourceDirectoryURI()).accept("application/xml").get(ResourceDirectory.class);
	}
	
	@Test
	public void verifyAppointmentsMetadataAtomLink(){
		AtomLinks links = resourceDirectory.getLink();
		for (AtomLink atomLink : links) {
			if(atomLink.getTitle().equals(LinkTitles.AppointmentsMetadata)){
				assertEquals(IntegrationTestConfiguration.getMobileHealthServerBaseUri()+"/appointment-service/metadata", atomLink.getHref().toString());
				return;
			}
		}
		
		fail("Appointments metadata atom link is not found");
	}

	@Test
	public void verifyAppointmentRequestsAtomLink(){
		AtomLinks links = resourceDirectory.getLink();
		for (AtomLink atomLink : links) {
			if(atomLink.getTitle().equals(LinkTitles.AppointmentRequests)){
				assertEquals(IntegrationTestConfiguration.getMobileHealthServerBaseUri()+"/appointment-service/appointment-requests", atomLink.getHref().toString());
				return;
			}
		}
		
		fail("Appointment Requests atom link is not found");
	}
	
	@Test
	public void getResourceAsJson() {
		String response = jerseyClient.resource(getResourceDirectoryURI()).accept("application/json").get(String.class);

		assertNotNull(response);
	}

	@Test
	public void getResourceAsAtom() {
		Document atomFeedAsXml = jerseyClient.resource(getResourceDirectoryURI()).accept("application/atom+xml").get(Document.class);
		assertEquals("rss", atomFeedAsXml.getChildNodes().item(0).getLocalName());
		SyndFeed atomFeed = AtomUtility.xmlToFeed(atomFeedAsXml);
		assertTrue(atomFeed.getEntries().size() > 0);
	}

	@Ignore
	public void xmlPerf() {
		executePerformanceTest(MediaType.APPLICATION_XML);
	}

	@Ignore
	public void jsonPerf() {
		executePerformanceTest(MediaType.APPLICATION_JSON);
	}

	@Ignore
	public void atomPerf() {
		executePerformanceTest(MediaType.APPLICATION_ATOM_XML);
	}

	private void executePerformanceTest(String mediatype) {
		final URI uri = getResourceDirectoryURI();
		final int numberOfRuns = 10000;

		for (int i = 0; i < numberOfRuns; i++) {
			jerseyClient.resource(uri).accept(mediatype).get(String.class);
		}
	}

	private URI getResourceDirectoryURI() {
		return IntegrationTestConfiguration.getHealthAdapterResourceDirectoryUri();
	}
}
