package com.agilex.healthcare.mobilehealthplatform.restservice;

import java.util.HashMap;

import org.junit.Assume;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.utility.ModeHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;

public class RecursiveLinkTest {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(RecursiveLinkTest.class);

	@Test
	public void validateResultSet() {
		Assume.assumeTrue(ModeHelper.isMode("va-provider-dev"));
		HashMap<String, String> resultSet = new HashMap<String, String>();
		String entryUri = "http://localhost:8080/MobileHealthPlatformWeb/rest/patients?searchstring=younger,gallow";
		validateUriAndChildren(entryUri, resultSet);

		logger.info(String.format("%s links have been tested", resultSet.size()));
	}

	private void validateUriAndChildren(String uri, HashMap<String, String> resultSet) {
		if (!resultSet.containsKey(uri)) {
			Client jerseyClient = null;
			try {
				jerseyClient = new Client();
				logger.debug("testing " + uri);
				ClientResponse head = jerseyClient.resource(uri).head();
				String mediaType = head.getHeaders().getFirst("Content-Type");
				Document result = jerseyClient.resource(uri).get(Document.class);
				logger.debug(uri + " succeeded");
				resultSet.put(uri, "success");

				logger.debug("media type " + mediaType);
				if (!mediaType.contains("image")) {
				NodeList links = XpathHelper.getNodeList(result, "//atom:link");
				logger.debug(uri + " has " + links.getLength() + " links");
				for (int i = 0; i < links.getLength(); i++) {
					Node linkNode = links.item(i);
					String childUri = XpathHelper.getString(linkNode, "@href");
					if (!resultSet.containsKey(childUri)) {
						validateUriAndChildren(childUri, resultSet);
					} else {
						logger.debug(childUri + " has already been tested, skipping");
					}
				}}
			} catch (Exception e) {
				logger.warn("failed to invoke uri [" + uri + "]");
				resultSet.put(uri, "failed");
			}
			if (jerseyClient != null) {
				jerseyClient.destroy();
				jerseyClient = null;
			}
		}

	}
}
